/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.MountExplodedMarker;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class DeploymentOverlayDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final ContentRepository contentRepository;
    protected static final AttachmentKey<AttachmentList<Closeable>> MOUNTED_FILES = AttachmentKey.createList(Closeable.class);
    protected static final AttachmentKey<Map<String, byte[]>> DEFERRED_OVERLAYS = AttachmentKey.create(Map.class);

    public DeploymentOverlayDeploymentUnitProcessor(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        Map<String, MountedDeploymentOverlay> mounts = this.getMountsAttachment(deploymentUnit);
        Map<String, byte[]> deferred = this.getDeferredAttachment(deploymentUnit);
        Map<String, byte[]> overlayEntries = this.getOverlays(deploymentUnit);
        if (overlayEntries == null) {
            return;
        }
        boolean exploded = MountExplodedMarker.isMountExploded(deploymentUnit) && !ExplodedDeploymentMarker.isExplodedDeployment(deploymentUnit);
        HashSet<String> paths = new HashSet<String>();
        for (Map.Entry<String, byte[]> entry : overlayEntries.entrySet()) {
            String path = entry.getKey();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            try {
                VirtualFile parent;
                if (paths.contains(path)) continue;
                VirtualFile mountPoint = deploymentRoot.getRoot().getChild(path);
                paths.add(path);
                VirtualFile content = this.contentRepository.getContent(entry.getValue());
                if (exploded) {
                    parent = mountPoint.getParent();
                    while (!parent.exists()) {
                        parent = parent.getParent();
                    }
                    if (parent.isDirectory()) {
                        DeploymentOverlayDeploymentUnitProcessor.copyFile(content.getPhysicalFile(), mountPoint.getPhysicalFile());
                        continue;
                    }
                    this.handleEntryWithFileParent(deferred, entry, path, parent);
                    continue;
                }
                parent = mountPoint.getParent();
                ArrayList<VirtualFile> createParents = new ArrayList<VirtualFile>();
                while (!parent.exists()) {
                    createParents.add(parent);
                    parent = parent.getParent();
                }
                if (parent.isDirectory()) {
                    Collections.reverse(createParents);
                    for (VirtualFile file : createParents) {
                        Closeable closable = VFS.mountTemp((VirtualFile)file, (TempFileProvider)TempFileProviderService.provider());
                        deploymentUnit.addToAttachmentList(MOUNTED_FILES, closable);
                    }
                    Closeable handle = VFS.mountReal((File)content.getPhysicalFile(), (VirtualFile)mountPoint);
                    MountedDeploymentOverlay mounted = new MountedDeploymentOverlay(handle, content.getPhysicalFile(), mountPoint, TempFileProviderService.provider());
                    deploymentUnit.addToAttachmentList(MOUNTED_FILES, mounted);
                    mounts.put(path, mounted);
                    continue;
                }
                this.handleEntryWithFileParent(deferred, entry, path, parent);
            }
            catch (IOException e) {
                throw ServerLogger.ROOT_LOGGER.deploymentOverlayFailed(e, entry.getKey(), path);
            }
        }
    }

    protected void handleEntryWithFileParent(Map<String, byte[]> deferred, Map.Entry<String, byte[]> entry, String path, VirtualFile parent) {
        deferred.put(path, entry.getValue());
    }

    protected Map<String, byte[]> getDeferredAttachment(DeploymentUnit deploymentUnit) {
        HashMap<String, byte[]> deferred = new HashMap<String, byte[]>();
        deploymentUnit.putAttachment(DEFERRED_OVERLAYS, deferred);
        return deferred;
    }

    protected Map<String, MountedDeploymentOverlay> getMountsAttachment(DeploymentUnit deploymentUnit) {
        HashMap<String, MountedDeploymentOverlay> mounts = new HashMap<String, MountedDeploymentOverlay>();
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS, mounts);
        return mounts;
    }

    protected Map<String, byte[]> getOverlays(DeploymentUnit deploymentUnit) {
        DeploymentOverlayIndex overlays = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_INDEX);
        if (overlays == null) {
            return null;
        }
        Map<String, byte[]> overlayEntries = overlays.getOverlays(deploymentUnit.getName());
        return overlayEntries;
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        for (Closeable closable : context.getAttachmentList(MOUNTED_FILES)) {
            try {
                closable.close();
            }
            catch (IOException e) {
                ServerLogger.DEPLOYMENT_LOGGER.failedToUnmountContentOverride(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(File src, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        try {
            DeploymentOverlayDeploymentUnitProcessor.copyFile(in, dest);
        }
        finally {
            DeploymentOverlayDeploymentUnitProcessor.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        byte[] buff = new byte[1024];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            int i = in.read(buff);
            while (i > 0) {
                ((OutputStream)out).write(buff, 0, i);
                i = in.read(buff);
            }
        }
        finally {
            DeploymentOverlayDeploymentUnitProcessor.close(out);
        }
    }

    protected static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

