/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.resources.LoginActionsService;

public class FormAuthenticationFlow
implements AuthenticationFlow {
    AuthenticationProcessor processor;
    AuthenticationExecutionModel formExecution;
    private final List<AuthenticationExecutionModel> formActionExecutions;
    private final FormAuthenticator formAuthenticator;

    public FormAuthenticationFlow(AuthenticationProcessor processor, AuthenticationExecutionModel execution) {
        this.processor = processor;
        this.formExecution = execution;
        this.formActionExecutions = processor.getRealm().getAuthenticationExecutions(execution.getFlowId());
        this.formAuthenticator = (FormAuthenticator)processor.getSession().getProvider(FormAuthenticator.class, execution.getAuthenticator());
    }

    @Override
    public Response processAction(String actionExecution) {
        if (!actionExecution.equals(this.formExecution.getId())) {
            throw new AuthenticationFlowException("action is not current execution", AuthenticationFlowError.INTERNAL_ERROR);
        }
        HashMap<String, ClientSessionModel.ExecutionStatus> executionStatus = new HashMap<String, ClientSessionModel.ExecutionStatus>();
        LinkedList<FormAction> requiredActions = new LinkedList<FormAction>();
        LinkedList<ValidationContextImpl> successes = new LinkedList<ValidationContextImpl>();
        LinkedList<ValidationContextImpl> errors = new LinkedList<ValidationContextImpl>();
        for (AuthenticationExecutionModel authenticationExecutionModel : this.formActionExecutions) {
            if (!authenticationExecutionModel.isEnabled()) {
                executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            FormActionFactory factory = (FormActionFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(FormAction.class, authenticationExecutionModel.getAuthenticator());
            FormAction action = (FormAction)factory.create(this.processor.getSession());
            UserModel authUser = this.processor.getClientSession().getAuthenticatedUser();
            if (action.requiresUser() && authUser == null) {
                throw new AuthenticationFlowException("form action: " + this.formExecution.getAuthenticator() + " requires user", AuthenticationFlowError.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (action.requiresUser() && authUser != null && !(configuredFor = action.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (authenticationExecutionModel.isRequired()) {
                    if (factory.isUserSetupAllowed()) {
                        AuthenticationProcessor.logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)this.formExecution.getAuthenticator());
                        executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        requiredActions.add(action);
                        continue;
                    }
                    throw new AuthenticationFlowException(AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
                }
                if (authenticationExecutionModel.isOptional()) {
                    executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            ValidationContextImpl result = new ValidationContextImpl(authenticationExecutionModel, action);
            action.validate(result);
            if (result.success) {
                executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
                successes.add(result);
                continue;
            }
            executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
            errors.add(result);
        }
        if (!errors.isEmpty()) {
            this.processor.logFailure();
            LinkedList<FormMessage> messages = new LinkedList<FormMessage>();
            HashSet<String> hashSet = new HashSet<String>();
            for (ValidationContextImpl v : errors) {
                for (FormMessage m : v.errors) {
                    if (hashSet.contains(m.getField())) continue;
                    hashSet.add(m.getField());
                    messages.add(m);
                }
            }
            ValidationContextImpl first = (ValidationContextImpl)errors.get(0);
            first.getEvent().error(first.error);
            return this.renderForm(first.formData, messages);
        }
        for (ValidationContextImpl validationContextImpl : successes) {
            validationContextImpl.action.success(validationContextImpl);
        }
        for (Map.Entry entry : executionStatus.entrySet()) {
            this.processor.getClientSession().setExecutionStatus((String)entry.getKey(), (ClientSessionModel.ExecutionStatus)entry.getValue());
        }
        for (FormAction formAction : requiredActions) {
            formAction.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getClientSession().getAuthenticatedUser());
        }
        this.processor.getClientSession().setExecutionStatus(actionExecution, ClientSessionModel.ExecutionStatus.SUCCESS);
        return this.processor.createSuccessRedirect();
    }

    public URI getActionUrl(String executionId, String code) {
        return LoginActionsService.registrationFormProcessor(this.processor.getUriInfo()).queryParam("code", new Object[]{code}).queryParam("execution", new Object[]{executionId}).build(new Object[]{this.processor.getRealm().getName()});
    }

    @Override
    public Response processFlow() {
        return this.renderForm(null, null);
    }

    public Response renderForm(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        String executionId = this.formExecution.getId();
        this.processor.getClientSession().setNote("current.authentication.execution", executionId);
        String code = this.processor.generateCode();
        URI actionUrl = this.getActionUrl(executionId, code);
        LoginFormsProvider form = ((LoginFormsProvider)this.processor.getSession().getProvider(LoginFormsProvider.class)).setActionUri(actionUrl).setClientSessionCode(code).setFormData(formData).setErrors(errors);
        for (AuthenticationExecutionModel formActionExecution : this.formActionExecutions) {
            if (!formActionExecution.isEnabled()) continue;
            FormAction action = (FormAction)this.processor.getSession().getProvider(FormAction.class, formActionExecution.getAuthenticator());
            FormContextImpl result = new FormContextImpl(formActionExecution);
            action.buildPage(result, form);
        }
        FormContextImpl context = new FormContextImpl(this.formExecution);
        return this.formAuthenticator.render(context, form);
    }

    private class ValidationContextImpl
    extends FormContextImpl
    implements ValidationContext {
        FormAction action;
        String error;
        boolean success;
        List<FormMessage> errors;
        MultivaluedMap<String, String> formData;

        private ValidationContextImpl(AuthenticationExecutionModel executionModel, FormAction action) {
            super(executionModel);
            this.errors = null;
            this.formData = null;
            this.action = action;
        }

        @Override
        public void validationError(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
            this.errors = errors;
            this.formData = formData;
        }

        @Override
        public void error(String error) {
            this.error = error;
        }

        @Override
        public void success() {
            this.success = true;
        }
    }

    private class FormContextImpl
    implements FormContext {
        AuthenticationExecutionModel executionModel;
        AuthenticatorConfigModel authenticatorConfig;

        private FormContextImpl(AuthenticationExecutionModel executionModel) {
            this.executionModel = executionModel;
        }

        @Override
        public EventBuilder newEvent() {
            return FormAuthenticationFlow.this.processor.newEvent();
        }

        @Override
        public EventBuilder getEvent() {
            return FormAuthenticationFlow.this.processor.getEvent();
        }

        @Override
        public AuthenticationExecutionModel getExecution() {
            return this.executionModel;
        }

        @Override
        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.executionModel.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = this.getRealm().getAuthenticatorConfigById(this.executionModel.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        @Override
        public UserModel getUser() {
            return this.getClientSession().getAuthenticatedUser();
        }

        @Override
        public void setUser(UserModel user) {
            FormAuthenticationFlow.this.processor.setAutheticatedUser(user);
        }

        @Override
        public RealmModel getRealm() {
            return FormAuthenticationFlow.this.processor.getRealm();
        }

        @Override
        public ClientSessionModel getClientSession() {
            return FormAuthenticationFlow.this.processor.getClientSession();
        }

        @Override
        public ClientConnection getConnection() {
            return FormAuthenticationFlow.this.processor.getConnection();
        }

        @Override
        public UriInfo getUriInfo() {
            return FormAuthenticationFlow.this.processor.getUriInfo();
        }

        @Override
        public KeycloakSession getSession() {
            return FormAuthenticationFlow.this.processor.getSession();
        }

        @Override
        public HttpRequest getHttpRequest() {
            return FormAuthenticationFlow.this.processor.getRequest();
        }
    }
}

