/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.OAuthErrorException;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.util.TokenUtil;

public class TokenManager {
    protected static final Logger logger = Logger.getLogger(TokenManager.class);

    public static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        for (RoleModel contained : scope.getComposites()) {
            TokenManager.applyScope(role, contained, visited, requested);
        }
    }

    public TokenValidation validateToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, AccessToken oldToken, HttpHeaders headers) throws OAuthErrorException {
        ClientSessionModel clientSession;
        UserSessionModel userSession;
        UserModel user;
        block9: {
            block8: {
                user = session.users().getUserById(oldToken.getSubject(), realm);
                if (user == null) {
                    throw new OAuthErrorException("invalid_grant", "Invalid refresh token", "Unknown user");
                }
                if (!user.isEnabled()) {
                    throw new OAuthErrorException("invalid_grant", "User disabled", "User disabled");
                }
                userSession = null;
                clientSession = null;
                if (!"Offline".equals(oldToken.getType())) break block8;
                UserSessionManager sessionManager = new UserSessionManager(session);
                clientSession = sessionManager.findOfflineClientSession(realm, oldToken.getClientSession(), oldToken.getSessionState());
                if (clientSession == null || (userSession = clientSession.getUserSession()).getLastSessionRefresh() >= Time.currentTime() - realm.getOfflineSessionIdleTimeout()) break block9;
                sessionManager.revokeOfflineUserSession(userSession);
                userSession = null;
                clientSession = null;
                break block9;
            }
            userSession = session.sessions().getUserSession(realm, oldToken.getSessionState());
            if (!AuthenticationManager.isSessionValid(realm, userSession)) {
                AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                throw new OAuthErrorException("invalid_grant", "Session not active", "Session not active");
            }
            for (ClientSessionModel clientSessionModel : userSession.getClientSessions()) {
                if (!clientSessionModel.getId().equals(oldToken.getClientSession())) continue;
                clientSession = clientSessionModel;
                break;
            }
        }
        if (clientSession == null) {
            throw new OAuthErrorException("invalid_grant", "Client session not active", "Client session not active");
        }
        ClientModel client = clientSession.getClient();
        if (!client.getClientId().equals(oldToken.getIssuedFor())) {
            throw new OAuthErrorException("invalid_grant", "Unmatching clients", "Unmatching clients");
        }
        if (oldToken.getIssuedAt() < client.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale token");
        }
        if (oldToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale token");
        }
        String scopeParam = clientSession.getNote("scope");
        Set<RoleModel> requestedRoles = TokenManager.getAccess(scopeParam, true, clientSession.getClient(), user);
        AccessToken newToken = this.createClientAccessToken(session, requestedRoles, realm, client, user, userSession, clientSession);
        this.verifyAccess(oldToken, newToken);
        return new TokenValidation(user, userSession, clientSession, newToken);
    }

    public RefreshResult refreshAccessToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, ClientModel authorizedClient, String encodedRefreshToken, EventBuilder event, HttpHeaders headers) throws OAuthErrorException {
        RefreshToken refreshToken = this.verifyRefreshToken(realm, encodedRefreshToken);
        event.user(refreshToken.getSubject()).session(refreshToken.getSessionState()).detail("refresh_token_id", refreshToken.getId()).detail("refresh_token_type", refreshToken.getType());
        TokenValidation validation = this.validateToken(session, uriInfo, connection, realm, (AccessToken)refreshToken, headers);
        if (!validation.clientSession.getClient().getId().equals(authorizedClient.getId())) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token. Token client and authorized client don't match");
        }
        int currentTime = Time.currentTime();
        if (realm.isRevokeRefreshToken()) {
            int serverStartupTime = (int)(session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L);
            if (refreshToken.getIssuedAt() < validation.clientSession.getTimestamp() && serverStartupTime != validation.clientSession.getTimestamp()) {
                throw new OAuthErrorException("invalid_grant", "Stale token");
            }
        }
        validation.clientSession.setTimestamp(currentTime);
        validation.userSession.setLastSessionRefresh(currentTime);
        AccessTokenResponse res = this.responseBuilder(realm, authorizedClient, event, session, validation.userSession, validation.clientSession).accessToken(validation.newToken).generateIDToken().generateRefreshToken().build();
        return new RefreshResult(res, "Offline".equals(refreshToken.getType()));
    }

    public RefreshToken verifyRefreshToken(RealmModel realm, String encodedRefreshToken) throws OAuthErrorException {
        JWSInput jws = new JWSInput(encodedRefreshToken);
        RefreshToken refreshToken = null;
        try {
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                throw new OAuthErrorException("invalid_grant", "Invalid refresh token");
            }
            refreshToken = (RefreshToken)jws.readJsonContent(RefreshToken.class);
        }
        catch (Exception e) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", (Throwable)e);
        }
        if (refreshToken.getExpiration() != 0 && refreshToken.isExpired()) {
            throw new OAuthErrorException("invalid_grant", "Refresh token expired");
        }
        if (refreshToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale refresh token");
        }
        return refreshToken;
    }

    public IDToken verifyIDToken(RealmModel realm, String encodedIDToken) throws OAuthErrorException {
        JWSInput jws = new JWSInput(encodedIDToken);
        IDToken idToken = null;
        try {
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                throw new OAuthErrorException("invalid_grant", "Invalid IDToken");
            }
            idToken = (IDToken)jws.readJsonContent(IDToken.class);
        }
        catch (IOException e) {
            throw new OAuthErrorException("invalid_grant", "Invalid IDToken", (Throwable)e);
        }
        if (idToken.isExpired()) {
            throw new OAuthErrorException("invalid_grant", "IDToken expired");
        }
        if (idToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale IDToken");
        }
        return idToken;
    }

    public AccessToken createClientAccessToken(KeycloakSession session, Set<RoleModel> requestedRoles, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        AccessToken token = this.initToken(realm, client, user, userSession, clientSession, session.getContext().getUri());
        for (RoleModel role : requestedRoles) {
            this.addComposites(token, role);
        }
        token = this.transformAccessToken(session, token, realm, client, user, userSession, clientSession);
        return token;
    }

    public static void attachClientSession(UserSessionModel session, ClientSessionModel clientSession) {
        if (clientSession.getUserSession() != null) {
            return;
        }
        UserModel user = session.getUser();
        clientSession.setUserSession(session);
        HashSet<String> requestedRoles = new HashSet<String>();
        String scopeParam = clientSession.getNote("scope");
        for (RoleModel roleModel : TokenManager.getAccess(scopeParam, true, clientSession.getClient(), user)) {
            requestedRoles.add(roleModel.getId());
        }
        clientSession.setRoles(requestedRoles);
        HashSet<String> requestedProtocolMappers = new HashSet<String>();
        for (ProtocolMapperModel protocolMapper : clientSession.getClient().getProtocolMappers()) {
            if (!protocolMapper.getProtocol().equals(clientSession.getAuthMethod())) continue;
            requestedProtocolMappers.add(protocolMapper.getId());
        }
        clientSession.setProtocolMappers(requestedProtocolMappers);
        Map map = clientSession.getUserSessionNotes();
        for (Map.Entry entry : map.entrySet()) {
            session.setNote((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void dettachClientSession(UserSessionProvider sessions, RealmModel realm, ClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession == null) {
            return;
        }
        clientSession.setUserSession(null);
        clientSession.setRoles(null);
        clientSession.setProtocolMappers(null);
        if (userSession.getClientSessions().isEmpty()) {
            sessions.removeUserSession(realm, userSession);
        }
    }

    public static Set<RoleModel> getAccess(String scopeParam, boolean applyScopeParam, ClientModel client, UserModel user) {
        HashSet<RoleModel> requestedRoles = new HashSet();
        Set roleMappings = user.getRoleMappings();
        if (client.isFullScopeAllowed()) {
            requestedRoles = roleMappings;
        } else {
            Set scopeMappings = client.getScopeMappings();
            scopeMappings.addAll(client.getRoles());
            for (RoleModel role : roleMappings) {
                for (RoleModel roleModel : scopeMappings) {
                    HashSet<RoleModel> visited = new HashSet<RoleModel>();
                    TokenManager.applyScope(role, roleModel, visited, requestedRoles);
                }
            }
        }
        if (applyScopeParam) {
            List<Object> scopeParamRoles;
            if (scopeParam != null) {
                String[] scopes = scopeParam.split(" ");
                scopeParamRoles = Arrays.asList(scopes);
            } else {
                scopeParamRoles = Collections.emptyList();
            }
            HashSet<Object> roles = new HashSet<Object>();
            for (RoleModel role : requestedRoles) {
                String string = TokenManager.getRoleNameForScopeParam(role);
                if (!role.isScopeParamRequired() || scopeParamRoles.contains(string)) {
                    roles.add(role);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.tracef("Role '%s' excluded by scope param. Client is '%s', User is '%s', Scope param is '%s' ", new Object[]{role.getName(), client.getClientId(), user.getUsername(), scopeParam});
            }
            LinkedList<RoleModel> scopeRoles = new LinkedList<RoleModel>();
            for (String string : scopeParamRoles) {
                RoleModel scopeParamRole = TokenManager.getRoleFromScopeParam(client.getRealm(), string);
                if (scopeParamRole == null) continue;
                for (RoleModel roleModel : roles) {
                    if (!roleModel.hasRole(scopeParamRole)) continue;
                    scopeRoles.add(scopeParamRole);
                }
            }
            roles.addAll(scopeRoles);
            requestedRoles = roles;
        }
        return requestedRoles;
    }

    private static String getRoleNameForScopeParam(RoleModel role) {
        if (role.getContainer() instanceof RealmModel) {
            return role.getName();
        }
        ClientModel client = (ClientModel)role.getContainer();
        return client.getClientId() + "/" + role.getName();
    }

    private static RoleModel getRoleFromScopeParam(RealmModel realm, String scopeParamRole) {
        String[] parts = scopeParamRole.split("/");
        if (parts.length == 1) {
            return realm.getRole(parts[0]);
        }
        ClientModel roleClient = realm.getClientByClientId(parts[0]);
        return roleClient != null ? roleClient.getRole(parts[1]) : null;
    }

    public void verifyAccess(AccessToken token, AccessToken newToken) throws OAuthErrorException {
        if (token.getRealmAccess() != null) {
            if (newToken.getRealmAccess() == null) {
                throw new OAuthErrorException("invalid_grant", "User no long has permission for realm roles");
            }
            for (String string : token.getRealmAccess().getRoles()) {
                if (newToken.getRealmAccess().getRoles().contains(string)) continue;
                throw new OAuthErrorException("invalid_grant", "User no long has permission for realm role: " + string);
            }
        }
        if (token.getResourceAccess() != null) {
            for (Map.Entry entry : token.getResourceAccess().entrySet()) {
                AccessToken.Access appAccess = newToken.getResourceAccess((String)entry.getKey());
                if (appAccess == null && !((AccessToken.Access)entry.getValue()).getRoles().isEmpty()) {
                    throw new OAuthErrorException("invalid_grant", "User or client no longer has role permissions for client key: " + (String)entry.getKey());
                }
                for (String roleName : ((AccessToken.Access)entry.getValue()).getRoles()) {
                    if (appAccess.getRoles().contains(roleName)) continue;
                    throw new OAuthErrorException("invalid_grant", "User no long has permission for client role " + roleName);
                }
            }
        }
    }

    public AccessToken transformAccessToken(KeycloakSession session, AccessToken token, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        Set<ProtocolMapperModel> mappings = new ClientSessionCode(realm, clientSession).getRequestedProtocolMappers();
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null || !(mapper instanceof OIDCAccessTokenMapper)) continue;
            token = ((OIDCAccessTokenMapper)((Object)mapper)).transformAccessToken(token, mapping, session, userSession, clientSession);
        }
        return token;
    }

    public void transformIDToken(KeycloakSession session, IDToken token, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        Set<ProtocolMapperModel> mappings = new ClientSessionCode(realm, clientSession).getRequestedProtocolMappers();
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null || !(mapper instanceof OIDCIDTokenMapper)) continue;
            token = ((OIDCIDTokenMapper)((Object)mapper)).transformIDToken(token, mapping, session, userSession, clientSession);
        }
    }

    protected AccessToken initToken(RealmModel realm, ClientModel client, UserModel user, UserSessionModel session, ClientSessionModel clientSession, UriInfo uriInfo) {
        Set allowedOrigins;
        AccessToken token = new AccessToken();
        if (clientSession != null) {
            token.clientSession(clientSession.getId());
        }
        token.id(KeycloakModelUtils.generateId());
        token.type("Bearer");
        token.subject(user.getId());
        token.audience(new String[]{client.getClientId()});
        token.issuedNow();
        token.issuedFor(client.getClientId());
        token.issuer(clientSession.getNote("iss"));
        token.setNonce(clientSession.getNote("nonce"));
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (realm.getAccessTokenLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getAccessTokenLifespan());
        }
        if ((allowedOrigins = client.getWebOrigins()) != null) {
            token.setAllowedOrigins(WebOriginsUtils.resolveValidWebOrigins(uriInfo, client));
        }
        return token;
    }

    protected void addComposites(AccessToken token, RoleModel role) {
        AccessToken.Access access = null;
        if (role.getContainer() instanceof RealmModel) {
            access = token.getRealmAccess();
            if (token.getRealmAccess() == null) {
                access = new AccessToken.Access();
                token.setRealmAccess(access);
            } else if (token.getRealmAccess().getRoles() != null && token.getRealmAccess().isUserInRole(role.getName())) {
                return;
            }
        } else {
            ClientModel app = (ClientModel)role.getContainer();
            access = token.getResourceAccess(app.getClientId());
            if (access == null) {
                access = token.addAccess(app.getClientId());
                if (app.isSurrogateAuthRequired()) {
                    access.verifyCaller(Boolean.valueOf(true));
                }
            } else if (access.isUserInRole(role.getName())) {
                return;
            }
        }
        access.addRole(role.getName());
        if (!role.isComposite()) {
            return;
        }
        for (RoleModel composite : role.getComposites()) {
            this.addComposites(token, composite);
        }
    }

    public String encodeToken(RealmModel realm, Object token) {
        String encodedToken = new JWSBuilder().jsonContent(token).rsa256(realm.getPrivateKey());
        return encodedToken;
    }

    public AccessTokenResponseBuilder responseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        return new AccessTokenResponseBuilder(realm, client, event, session, userSession, clientSession);
    }

    public class RefreshResult {
        private final AccessTokenResponse response;
        private final boolean offlineToken;

        private RefreshResult(AccessTokenResponse response, boolean offlineToken) {
            this.response = response;
            this.offlineToken = offlineToken;
        }

        public AccessTokenResponse getResponse() {
            return this.response;
        }

        public boolean isOfflineToken() {
            return this.offlineToken;
        }
    }

    public class AccessTokenResponseBuilder {
        RealmModel realm;
        ClientModel client;
        EventBuilder event;
        KeycloakSession session;
        UserSessionModel userSession;
        ClientSessionModel clientSession;
        AccessToken accessToken;
        RefreshToken refreshToken;
        IDToken idToken;

        public AccessTokenResponseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
            this.realm = realm;
            this.client = client;
            this.event = event;
            this.session = session;
            this.userSession = userSession;
            this.clientSession = clientSession;
        }

        public AccessTokenResponseBuilder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AccessTokenResponseBuilder refreshToken(RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AccessTokenResponseBuilder generateAccessToken() {
            UserModel user = this.userSession.getUser();
            String scopeParam = this.clientSession.getNote("scope");
            Set<RoleModel> requestedRoles = TokenManager.getAccess(scopeParam, true, this.client, user);
            this.accessToken = TokenManager.this.createClientAccessToken(this.session, requestedRoles, this.realm, this.client, user, this.userSession, this.clientSession);
            return this;
        }

        public AccessTokenResponseBuilder generateRefreshToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            String scopeParam = this.clientSession.getNote("scope");
            boolean offlineTokenRequested = TokenUtil.isOfflineTokenRequested((String)scopeParam);
            if (offlineTokenRequested) {
                UserSessionManager sessionManager = new UserSessionManager(this.session);
                if (!sessionManager.isOfflineTokenAllowed(this.clientSession)) {
                    this.event.error("not_allowed");
                    throw new ErrorResponseException("not_allowed", "Offline tokens not allowed for the user or client", Response.Status.BAD_REQUEST);
                }
                this.refreshToken = new RefreshToken(this.accessToken);
                this.refreshToken.type("Offline");
                sessionManager.createOrUpdateOfflineSession(this.clientSession, this.userSession);
            } else {
                this.refreshToken = new RefreshToken(this.accessToken);
                this.refreshToken.expiration(Time.currentTime() + this.realm.getSsoSessionIdleTimeout());
            }
            this.refreshToken.id(KeycloakModelUtils.generateId());
            this.refreshToken.issuedNow();
            return this;
        }

        public AccessTokenResponseBuilder generateIDToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.idToken = new IDToken();
            this.idToken.id(KeycloakModelUtils.generateId());
            this.idToken.type("ID");
            this.idToken.subject(this.accessToken.getSubject());
            this.idToken.audience(new String[]{this.client.getClientId()});
            this.idToken.issuedNow();
            this.idToken.issuedFor(this.accessToken.getIssuedFor());
            this.idToken.issuer(this.accessToken.getIssuer());
            this.idToken.setNonce(this.accessToken.getNonce());
            this.idToken.setSessionState(this.accessToken.getSessionState());
            if (this.realm.getAccessTokenLifespan() > 0) {
                this.idToken.expiration(Time.currentTime() + this.realm.getAccessTokenLifespan());
            }
            TokenManager.this.transformIDToken(this.session, this.idToken, this.realm, this.client, this.userSession.getUser(), this.userSession, this.clientSession);
            return this;
        }

        public AccessTokenResponse build() {
            String encodedToken;
            if (this.accessToken != null) {
                this.event.detail("token_id", this.accessToken.getId());
            }
            if (this.refreshToken != null) {
                if (this.event.getEvent().getDetails().containsKey("refresh_token_id")) {
                    this.event.detail("updated_refresh_token_id", this.refreshToken.getId());
                } else {
                    this.event.detail("refresh_token_id", this.refreshToken.getId());
                }
                this.event.detail("refresh_token_type", this.refreshToken.getType());
            }
            AccessTokenResponse res = new AccessTokenResponse();
            if (this.idToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.idToken).rsa256(this.realm.getPrivateKey());
                res.setIdToken(encodedToken);
            }
            if (this.accessToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.accessToken).rsa256(this.realm.getPrivateKey());
                res.setToken(encodedToken);
                res.setTokenType("bearer");
                res.setSessionState(this.accessToken.getSessionState());
                if (this.accessToken.getExpiration() != 0) {
                    res.setExpiresIn((long)(this.accessToken.getExpiration() - Time.currentTime()));
                }
            }
            if (this.refreshToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.refreshToken).rsa256(this.realm.getPrivateKey());
                res.setRefreshToken(encodedToken);
                if (this.refreshToken.getExpiration() != 0) {
                    res.setRefreshExpiresIn((long)(this.refreshToken.getExpiration() - Time.currentTime()));
                }
            }
            int notBefore = this.realm.getNotBefore();
            if (this.client.getNotBefore() > notBefore) {
                notBefore = this.client.getNotBefore();
            }
            res.setNotBeforePolicy(notBefore);
            return res;
        }
    }

    public static class TokenValidation {
        public final UserModel user;
        public final UserSessionModel userSession;
        public final ClientSessionModel clientSession;
        public final AccessToken newToken;

        public TokenValidation(UserModel user, UserSessionModel userSession, ClientSessionModel clientSession, AccessToken newToken) {
            this.user = user;
            this.userSession = userSession;
            this.clientSession = clientSession;
            this.newToken = newToken;
        }
    }
}

