/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;

public class AttackDetectionResource {
    protected static final Logger logger = Logger.getLogger(AttackDetectionResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ClientConnection connection;
    @Context
    protected HttpHeaders headers;
    @Context
    protected BruteForceProtector protector;

    public AttackDetectionResource(RealmAuth auth, RealmModel realm, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.realm(realm);
        auth.init(RealmAuth.Resource.REALM);
    }

    @GET
    @Path(value="brute-force/usernames/{username}")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Object> bruteForceUserStatus(@PathParam(value="username") String username) {
        this.auth.hasView();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("disabled", false);
        data.put("numFailures", 0);
        data.put("lastFailure", 0);
        data.put("lastIPFailure", "n/a");
        if (!this.realm.isBruteForceProtected()) {
            return data;
        }
        UsernameLoginFailureModel model = this.session.sessions().getUserLoginFailure(this.realm, username);
        if (model == null) {
            return data;
        }
        if (this.protector.isTemporarilyDisabled(this.session, this.realm, username)) {
            data.put("disabled", true);
        }
        data.put("numFailures", model.getNumFailures());
        data.put("lastFailure", model.getLastFailure());
        data.put("lastIPFailure", model.getLastIPFailure());
        return data;
    }

    @Path(value="brute-force/usernames/{username}")
    @DELETE
    public void clearBruteForceForUser(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UsernameLoginFailureModel model = this.session.sessions().getUserLoginFailure(this.realm, username);
        if (model != null) {
            this.session.sessions().removeUserLoginFailure(this.realm, username);
            this.adminEvent.operation(OperationType.DELETE).success();
        }
    }

    @Path(value="brute-force/usernames")
    @DELETE
    public void clearAllBruteForce() {
        this.auth.requireManage();
        this.session.sessions().removeAllUserLoginFailures(this.realm);
        this.adminEvent.operation(OperationType.DELETE).success();
    }
}

