/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.info;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.ProtocolMapperTypeRepresentation;
import org.keycloak.services.resources.admin.info.MemoryInfoRepresentation;
import org.keycloak.services.resources.admin.info.ProviderRepresentation;
import org.keycloak.services.resources.admin.info.ServerInfoRepresentation;
import org.keycloak.services.resources.admin.info.SpiInfoRepresentation;
import org.keycloak.services.resources.admin.info.SystemInfoRepresentation;
import org.keycloak.social.SocialIdentityProvider;

public class ServerInfoAdminResource {
    private static final Map<String, List<String>> ENUMS = ServerInfoAdminResource.createEnumsMap(EventType.class, OperationType.class);
    @Context
    private KeycloakSession session;

    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.setSystemInfo(SystemInfoRepresentation.create(this.session));
        info.setMemoryInfo(MemoryInfoRepresentation.create());
        this.setSocialProviders(info);
        this.setIdentityProviders(info);
        this.setThemes(info);
        this.setProviders(info);
        this.setProtocolMapperTypes(info);
        this.setBuiltinProtocolMappers(info);
        info.setEnums(ENUMS);
        return info;
    }

    private void setProviders(ServerInfoRepresentation info) {
        LinkedHashMap<String, SpiInfoRepresentation> spiReps = new LinkedHashMap<String, SpiInfoRepresentation>();
        LinkedList<Spi> spis = new LinkedList<Spi>();
        for (Spi spi : ServiceLoader.load(Spi.class)) {
            spis.add(spi);
        }
        Collections.sort(spis, new Comparator<Spi>(){

            @Override
            public int compare(Spi s1, Spi s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        for (Spi spi : spis) {
            SpiInfoRepresentation spiRep = new SpiInfoRepresentation();
            spiRep.setInternal(spi.isInternal());
            spiRep.setSystemInfo(ServerInfoAwareProviderFactory.class.isAssignableFrom(spi.getProviderFactoryClass()));
            LinkedList providerIds = new LinkedList(this.session.listProviderIds(spi.getProviderClass()));
            Collections.sort(providerIds);
            HashMap<String, ProviderRepresentation> providers = new HashMap<String, ProviderRepresentation>();
            if (providerIds != null) {
                for (String name : providerIds) {
                    ProviderRepresentation provider = new ProviderRepresentation();
                    if (spiRep.isSystemInfo()) {
                        provider.setOperationalInfo(((ServerInfoAwareProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(spi.getProviderClass(), name)).getOperationalInfo());
                    }
                    providers.put(name, provider);
                }
            }
            spiRep.setProviders(providers);
            spiReps.put(spi.getName(), spiRep);
        }
        info.setProviders(spiReps);
    }

    private void setThemes(ServerInfoRepresentation info) {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        info.setThemes(new HashMap<String, List<String>>());
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themes = new LinkedList(themeProvider.nameSet(type));
            Collections.sort(themes);
            info.getThemes().put(type.toString().toLowerCase(), themes);
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.setSocialProviders(new LinkedList<Map<String, String>>());
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getSocialProviders(), "Social");
    }

    private void setIdentityProviders(ServerInfoRepresentation info) {
        info.setIdentityProviders(new LinkedList<Map<String, String>>());
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "User-defined");
        providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "Social");
    }

    public void setIdentityProviders(List<ProviderFactory> factories, List<Map<String, String>> providers, String groupName) {
        for (ProviderFactory providerFactory : factories) {
            IdentityProviderFactory factory = (IdentityProviderFactory)providerFactory;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("groupName", groupName);
            data.put("name", factory.getName());
            data.put("id", factory.getId());
            providers.add(data);
        }
    }

    private void setProtocolMapperTypes(ServerInfoRepresentation info) {
        info.setProtocolMapperTypes(new HashMap<String, List<ProtocolMapperTypeRepresentation>>());
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(ProtocolMapper.class)) {
            ProtocolMapper mapper = (ProtocolMapper)p;
            List<ProtocolMapperTypeRepresentation> types = info.getProtocolMapperTypes().get(mapper.getProtocol());
            if (types == null) {
                types = new LinkedList<ProtocolMapperTypeRepresentation>();
                info.getProtocolMapperTypes().put(mapper.getProtocol(), types);
            }
            ProtocolMapperTypeRepresentation rep = new ProtocolMapperTypeRepresentation();
            rep.setId(mapper.getId());
            rep.setName(mapper.getDisplayType());
            rep.setHelpText(mapper.getHelpText());
            rep.setCategory(mapper.getDisplayCategory());
            rep.setProperties(new LinkedList());
            List configProperties = mapper.getConfigProperties();
            for (ProviderConfigProperty prop : configProperties) {
                ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
                propRep.setName(prop.getName());
                propRep.setLabel(prop.getLabel());
                propRep.setType(prop.getType());
                propRep.setDefaultValue(prop.getDefaultValue());
                propRep.setHelpText(prop.getHelpText());
                rep.getProperties().add(propRep);
            }
            types.add(rep);
        }
    }

    private void setBuiltinProtocolMappers(ServerInfoRepresentation info) {
        info.setBuiltinProtocolMappers(new HashMap<String, List<ProtocolMapperRepresentation>>());
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class)) {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel mapper : factory.getBuiltinMappers()) {
                mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
            }
            info.getBuiltinProtocolMappers().put(p.getId(), mappers);
        }
    }

    private static Map<String, List<String>> createEnumsMap(Class ... enums) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (Class e : enums) {
            String n = e.getSimpleName();
            n = Character.toLowerCase(n.charAt(0)) + n.substring(1);
            LinkedList<String> l = new LinkedList<String>();
            for (Object c : e.getEnumConstants()) {
                l.add(c.toString());
            }
            Collections.sort(l);
            m.put(n, l);
        }
        return m;
    }
}

