/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class ExpiredEntryMonitor
extends Thread {
    private boolean _skipNext;
    private boolean _stop;
    private static Vector _expiryScanners;
    private static boolean initialised;
    private static int _scanIntervalSeconds;
    private static SimpleDateFormat _theTimestamper;
    private static boolean _skipFirst;
    private static ExpiredEntryMonitor _theInstance;

    public static synchronized boolean startUp() {
        if (_theInstance != null) {
            return false;
        }
        if (!initialised) {
            ExpiredEntryMonitor.initialise();
        }
        if (_scanIntervalSeconds == 0) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"Expiry scan zero - not scanning");
            }
            return false;
        }
        if (_expiryScanners.size() == 0) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"No Expiry scanners loaded - not scanning");
            }
            return false;
        }
        _theInstance = new ExpiredEntryMonitor(_skipFirst);
        _theInstance.start();
        return true;
    }

    public static synchronized void shutdown() {
        if (_theInstance != null) {
            _theInstance.terminate();
            try {
                _theInstance.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        _theInstance = null;
    }

    private ExpiredEntryMonitor(boolean skipFirst) {
        super("Transaction Expired Entry Monitor");
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"ExpiredEntryMonitor - constructed");
        }
        this._skipNext = skipFirst;
        this._stop = false;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object scanners;
            tsLogger.i18NLogger.info_recovery_ExpiredEntryMonitor_12(_theTimestamper.format(new Date()));
            if (this._skipNext) {
                this._skipNext = false;
                tsLogger.i18NLogger.info_recovery_ExpiredEntryMonitor_5();
            } else {
                scanners = _expiryScanners.elements();
                while (scanners.hasMoreElements()) {
                    ExpiryScanner m = (ExpiryScanner)scanners.nextElement();
                    ExpiredEntryMonitor expiredEntryMonitor = this;
                    synchronized (expiredEntryMonitor) {
                        if (this._stop) {
                            break;
                        }
                    }
                    m.scan();
                    if (!tsLogger.logger.isDebugEnabled()) continue;
                    tsLogger.logger.debug((Object)"  ");
                }
            }
            try {
                scanners = this;
                synchronized (scanners) {
                    if (this._stop) {
                        break;
                    }
                    this.wait(_scanIntervalSeconds * 1000);
                    if (this._stop) {
                        break;
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private synchronized void terminate() {
        this._stop = true;
        this.notify();
    }

    private static void initialise() {
        _scanIntervalSeconds = recoveryPropertyManager.getRecoveryEnvironmentBean().getExpiryScanInterval() * 60 * 60;
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("Expiry scan interval set to " + Integer.toString(_scanIntervalSeconds) + " seconds"));
        }
        if (_scanIntervalSeconds != 0) {
            if (_scanIntervalSeconds < 0) {
                _skipFirst = true;
                _scanIntervalSeconds = -_scanIntervalSeconds;
            }
            ExpiredEntryMonitor.loadScanners();
        }
        initialised = true;
    }

    private static void loadScanners() {
        _expiryScanners = new Vector();
        for (ExpiryScanner scanner : recoveryPropertyManager.getRecoveryEnvironmentBean().getExpiryScanners()) {
            if (!scanner.toBeUsed()) continue;
            _expiryScanners.add(scanner);
        }
    }

    static {
        initialised = false;
        _scanIntervalSeconds = 43200;
        _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        _skipFirst = false;
        _theInstance = null;
    }
}

