/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class RetryOnFailureOperation<T>
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(RetryOnFailureOperation.class, Log.class);
    protected final TransportFactory transportFactory;
    private boolean triedCompleteRestart = false;

    protected RetryOnFailureOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, flags, cacheName, topologyId);
        this.transportFactory = transportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute() {
        int retryCount = 0;
        HashSet<SocketAddress> failedServers = null;
        while (this.shouldRetry(retryCount)) {
            Transport transport = null;
            try {
                transport = this.getTransport(retryCount, failedServers);
                T t = this.executeOperation(transport);
                return t;
            }
            catch (TransportException te) {
                if (failedServers == null) {
                    failedServers = new HashSet<SocketAddress>();
                }
                failedServers.add(te.getServerAddress());
                if (transport != null) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Invalidating transport %s as a result of transport exception", transport);
                    }
                    this.transportFactory.invalidateTransport(te.getServerAddress(), transport);
                }
                retryCount = this.logTransportErrorAndThrowExceptionIfNeeded(retryCount, te);
            }
            catch (RemoteIllegalLifecycleStateException | RemoteNodeSuspectException e) {
                this.logErrorAndThrowExceptionIfNeeded(retryCount, e);
            }
            finally {
                this.releaseTransport(transport);
            }
            ++retryCount;
        }
        throw new IllegalStateException("We should not reach here!");
    }

    protected boolean shouldRetry(int retryCount) {
        return retryCount <= this.transportFactory.getMaxRetries();
    }

    protected int logTransportErrorAndThrowExceptionIfNeeded(int i, TransportException e) {
        String message = "Exception encountered. Retry %d out of %d";
        if (i >= this.transportFactory.getMaxRetries() || this.transportFactory.getMaxRetries() < 0) {
            if (!this.triedCompleteRestart) {
                log.debug("Cluster might have completely shut down, try resetting transport layer and topology id", e);
                this.transportFactory.reset(this.cacheName);
                this.triedCompleteRestart = true;
                return -1;
            }
            log.exceptionAndNoRetriesLeft(i, this.transportFactory.getMaxRetries(), e);
            throw e;
        }
        log.tracef(e, message, i, this.transportFactory.getMaxRetries());
        return i;
    }

    protected void logErrorAndThrowExceptionIfNeeded(int i, HotRodClientException e) {
        String message = "Exception encountered. Retry %d out of %d";
        if (i >= this.transportFactory.getMaxRetries() || this.transportFactory.getMaxRetries() < 0) {
            log.exceptionAndNoRetriesLeft(i, this.transportFactory.getMaxRetries(), e);
            throw e;
        }
        log.tracef(e, message, i, this.transportFactory.getMaxRetries());
    }

    protected void releaseTransport(Transport transport) {
        if (transport != null) {
            this.transportFactory.releaseTransport(transport);
        }
    }

    protected abstract Transport getTransport(int var1, Set<SocketAddress> var2);

    protected abstract T executeOperation(Transport var1);
}

