/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.freemarker.ExtendingThemeManagerFactory;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.KeycloakSession;

public class ExtendingThemeManager
implements ThemeProvider {
    private static final Logger log = Logger.getLogger(ExtendingThemeManager.class);
    private final KeycloakSession session;
    private final ConcurrentHashMap<ExtendingThemeManagerFactory.ThemeKey, Theme> themeCache;
    private List<ThemeProvider> providers;
    private String defaultTheme;

    public ExtendingThemeManager(KeycloakSession session, ConcurrentHashMap<ExtendingThemeManagerFactory.ThemeKey, Theme> themeCache) {
        this.session = session;
        this.themeCache = themeCache;
        this.defaultTheme = Config.scope((String[])new String[]{"theme"}).get("default", "keycloak");
    }

    private List<ThemeProvider> getProviders() {
        if (this.providers == null) {
            this.providers = new LinkedList<ThemeProvider>();
            for (ThemeProvider p : this.session.getAllProviders(ThemeProvider.class)) {
                if (p instanceof ExtendingThemeManager || p.getClass().equals(ExtendingThemeManager.class)) continue;
                this.providers.add(p);
            }
            Collections.sort(this.providers, new Comparator<ThemeProvider>(){

                @Override
                public int compare(ThemeProvider o1, ThemeProvider o2) {
                    return o2.getProviderPriority() - o1.getProviderPriority();
                }
            });
        }
        return this.providers;
    }

    @Override
    public int getProviderPriority() {
        return 0;
    }

    @Override
    public Theme getTheme(String name, Theme.Type type) throws IOException {
        if (name == null) {
            name = this.defaultTheme;
        }
        if (this.themeCache != null) {
            ExtendingThemeManagerFactory.ThemeKey key = ExtendingThemeManagerFactory.ThemeKey.get(name, type);
            Theme theme = this.themeCache.get(key);
            if (theme == null) {
                theme = this.loadTheme(name, type);
                if (theme == null) {
                    theme = this.loadTheme("keycloak", type);
                    if (theme == null) {
                        theme = this.loadTheme("base", type);
                    }
                    log.errorv("Failed to find {0} theme {1}, using built-in themes", (Object)type, (Object)name);
                } else if (this.themeCache.putIfAbsent(key, theme) != null) {
                    theme = this.themeCache.get(key);
                }
            }
            return theme;
        }
        return this.loadTheme(name, type);
    }

    private Theme loadTheme(String name, Theme.Type type) throws IOException {
        Theme theme = this.findTheme(name, type);
        if (theme != null && (theme.getParentName() != null || theme.getImportName() != null)) {
            LinkedList<Theme> themes = new LinkedList<Theme>();
            themes.add(theme);
            if (theme.getImportName() != null) {
                String[] s = theme.getImportName().split("/");
                themes.add(this.findTheme(s[1], Theme.Type.valueOf(s[0].toUpperCase())));
            }
            if (theme.getParentName() != null) {
                String parentName = theme.getParentName();
                while (parentName != null) {
                    theme = this.findTheme(parentName, type);
                    themes.add(theme);
                    if (theme.getImportName() != null) {
                        String[] s = theme.getImportName().split("/");
                        themes.add(this.findTheme(s[1], Theme.Type.valueOf(s[0].toUpperCase())));
                    }
                    parentName = theme.getParentName();
                }
            }
            return new ExtendingTheme(themes);
        }
        return theme;
    }

    @Override
    public Set<String> nameSet(Theme.Type type) {
        HashSet<String> themes = new HashSet<String>();
        for (ThemeProvider p : this.getProviders()) {
            themes.addAll(p.nameSet(type));
        }
        return themes;
    }

    @Override
    public boolean hasTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        this.providers = null;
    }

    private Theme findTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            try {
                return p.getTheme(name, type);
            }
            catch (IOException e) {
                log.errorv((Throwable)e, p.getClass() + " failed to load theme, type={0}, name={1}", (Object)type, (Object)name);
            }
        }
        return null;
    }

    public static class ExtendingTheme
    implements Theme {
        private List<Theme> themes;

        public ExtendingTheme(List<Theme> themes) {
            this.themes = themes;
        }

        @Override
        public String getName() {
            return this.themes.get(0).getName();
        }

        @Override
        public String getParentName() {
            return this.themes.get(0).getParentName();
        }

        @Override
        public String getImportName() {
            return this.themes.get(0).getImportName();
        }

        @Override
        public Theme.Type getType() {
            return this.themes.get(0).getType();
        }

        @Override
        public URL getTemplate(String name) throws IOException {
            for (Theme t : this.themes) {
                URL template = t.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        @Override
        public InputStream getTemplateAsStream(String name) throws IOException {
            for (Theme t : this.themes) {
                InputStream template = t.getTemplateAsStream(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        @Override
        public URL getResource(String path) throws IOException {
            for (Theme t : this.themes) {
                URL resource = t.getResource(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String path) throws IOException {
            for (Theme t : this.themes) {
                InputStream resource = t.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        public Properties getMessages(Locale locale) throws IOException {
            return this.getMessages("messages", locale);
        }

        @Override
        public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
            Properties messages = new Properties();
            ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
            while (itr.hasPrevious()) {
                Properties m = itr.previous().getMessages(baseBundlename, locale);
                if (m == null) continue;
                messages.putAll((Map<?, ?>)m);
            }
            return messages;
        }

        @Override
        public Properties getProperties() throws IOException {
            Properties properties = new Properties();
            ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
            while (itr.hasPrevious()) {
                Properties p = itr.previous().getProperties();
                if (p == null) continue;
                properties.putAll((Map<?, ?>)p);
            }
            return properties;
        }
    }
}

