/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.hql.QueryParser;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.ObjectFilterImpl;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.FilterProcessingChain;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;

abstract class BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements Matcher {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private final QueryParser queryParser = new QueryParser();
    private final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();
    protected final Map<String, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filtersByTypeName = new HashMap<String, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>>();
    protected final Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filtersByType = new HashMap<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>>();

    BaseMatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void match(Object userContext, Object instance, Object eventType) {
        if (instance == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx = this.startContext(userContext, instance, eventType);
            if (ctx != null) {
                ctx.match();
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public ObjectFilter getObjectFilter(Query query) {
        BaseQuery baseQuery = (BaseQuery)query;
        return this.getObjectFilter(baseQuery.getJPAQuery());
    }

    @Override
    public ObjectFilter getObjectFilter(String jpaQuery) {
        FilterParsingResult<TypeMetadata> parsingResult = this.parse(jpaQuery);
        BooleanExpr normalizedFilter = this.booleanFilterNormalizer.normalize(parsingResult.getQuery());
        return new ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId>(this, this.createMetadataAdapter(parsingResult.getTargetEntityMetadata()), jpaQuery, parsingResult, normalizedFilter);
    }

    @Override
    public ObjectFilter getObjectFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        return this.getObjectFilter(filterSubscriptionImpl.getQueryString());
    }

    @Override
    public FilterSubscription registerFilter(Query query, FilterCallback callback, Object ... eventType) {
        BaseQuery baseQuery = (BaseQuery)query;
        return this.registerFilter(baseQuery.getJPAQuery(), callback, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterSubscription registerFilter(String jpaQuery, FilterCallback callback, Object ... eventType) {
        FilterParsingResult<TypeMetadata> parsingResult = this.parse(jpaQuery);
        BooleanExpr normalizedFilter = this.booleanFilterNormalizer.normalize(parsingResult.getQuery());
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = this.filtersByTypeName.get(parsingResult.getTargetEntityName());
            if (filterRegistry == null) {
                filterRegistry = new FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>(this.createMetadataAdapter(parsingResult.getTargetEntityMetadata()), true);
                this.filtersByTypeName.put(parsingResult.getTargetEntityName(), filterRegistry);
                this.filtersByType.put(filterRegistry.getMetadataAdapter().getTypeMetadata(), filterRegistry);
            }
            FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscriptionImpl = filterRegistry.addFilter(jpaQuery, normalizedFilter, parsingResult.getProjections(), parsingResult.getSortFields(), callback, eventType);
            return filterSubscriptionImpl;
        }
        finally {
            this.write.unlock();
        }
    }

    private FilterParsingResult<TypeMetadata> parse(String jpaQuery) {
        return (FilterParsingResult)this.queryParser.parseQuery(jpaQuery, this.createFilterProcessingChain(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = this.filtersByTypeName.get(filterSubscriptionImpl.getEntityTypeName());
            if (filterRegistry == null) {
                throw new IllegalStateException("Reached illegal state");
            }
            filterRegistry.removeFilter(filterSubscription);
            if (filterRegistry.getNumFilters() == 0) {
                this.filtersByTypeName.remove(filterRegistry.getMetadataAdapter().getTypeName());
                this.filtersByType.remove(filterRegistry.getMetadataAdapter().getTypeMetadata());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startContext(Object var1, Object var2, Object var3);

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startContext(Object var1, Object var2, FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> var3, Object var4);

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> createContext(Object var1, Object var2, Object var3);

    protected abstract FilterProcessingChain<TypeMetadata> createFilterProcessingChain(Map<String, Object> var1);

    protected abstract MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> createMetadataAdapter(TypeMetadata var1);

    protected abstract FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> getFilterRegistryForType(TypeMetadata var1);
}

