/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.saaj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.HTTPConduit;
import org.jboss.wsf.stack.cxf.Messages;

public class SOAPConnectionImpl
extends SOAPConnection {
    private volatile boolean closed = false;

    public SOAPMessage call(SOAPMessage msgOut, Object addressObject) throws SOAPException {
        this.checkClosed();
        String address = this.getAddress(addressObject);
        ConduitInitiator ci = this.getConduitInitiator(address);
        EndpointInfo info = new EndpointInfo();
        info.setAddress(address);
        MessageImpl outMessage = new MessageImpl();
        ExchangeImpl exch = new ExchangeImpl();
        outMessage.setExchange((Exchange)exch);
        try {
            Conduit c = ci.getConduit(info, BusFactory.getThreadDefaultBus((boolean)false));
            if (msgOut.saveRequired()) {
                msgOut.saveChanges();
            }
            HashMap<String, ArrayList<String>> outHeaders = new HashMap<String, ArrayList<String>>();
            Iterator it = msgOut.getMimeHeaders().getAllHeaders();
            while (it.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)it.next();
                if ("Content-Type".equals(mimeHeader.getName())) {
                    outMessage.put((Object)"Content-Type", (Object)mimeHeader.getValue());
                }
                if ("Transfer-Encoding".equals(mimeHeader.getName()) && "disabled".equals(mimeHeader.getValue()) && c instanceof HTTPConduit) {
                    ((HTTPConduit)c).getClient().setAllowChunking(false);
                    continue;
                }
                ArrayList<String> values = (ArrayList<String>)outHeaders.get(mimeHeader.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    outHeaders.put(mimeHeader.getName(), values);
                }
                values.add(mimeHeader.getValue());
            }
            outMessage.put((Object)"org.apache.cxf.request.method", (Object)"POST");
            outMessage.put((Object)Message.PROTOCOL_HEADERS, outHeaders);
            c.prepare((Message)outMessage);
            OutputStream outs = (OutputStream)outMessage.getContent(OutputStream.class);
            msgOut.writeTo(outs);
            c.setMessageObserver(this.createMessageObserver(c));
            c.close((Message)outMessage);
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.soapMessageCouldNotBeSent(ex);
        }
        return this.readSoapMessage((Exchange)exch);
    }

    public SOAPMessage get(Object addressObject) throws SOAPException {
        this.checkClosed();
        String address = this.getAddress(addressObject);
        ConduitInitiator ci = this.getConduitInitiator(address);
        EndpointInfo info = new EndpointInfo();
        info.setAddress(address);
        MessageImpl outMessage = new MessageImpl();
        ExchangeImpl exch = new ExchangeImpl();
        outMessage.setExchange((Exchange)exch);
        try {
            Conduit c = ci.getConduit(info, BusFactory.getThreadDefaultBus((boolean)false));
            if (c instanceof HTTPConduit) {
                ((HTTPConduit)c).getClient().setAutoRedirect(true);
            }
            outMessage.put((Object)"org.apache.cxf.request.method", (Object)"GET");
            c.prepare((Message)outMessage);
            c.setMessageObserver(this.createMessageObserver(c));
            c.close((Message)outMessage);
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.getRequestCouldNotBeSent(ex);
        }
        return this.readSoapMessage((Exchange)exch);
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw Messages.MESSAGES.connectionAlreadyClosed();
        }
        this.closed = true;
    }

    private String getAddress(Object addressObject) throws SOAPException {
        if (addressObject instanceof URL || addressObject instanceof String) {
            return addressObject.toString();
        }
        throw Messages.MESSAGES.addressTypeNotSupported(addressObject.getClass());
    }

    private ConduitInitiator getConduitInitiator(String address) throws SOAPException {
        ConduitInitiator ci = null;
        try {
            Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
            }
            ConduitInitiatorManager mgr = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
            if (address.startsWith("http")) {
                ci = mgr.getConduitInitiator("http://cxf.apache.org/transports/http");
            }
            if (ci == null) {
                ci = mgr.getConduitInitiatorForUri(address);
            }
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.noConduitInitiatorAvailableFor2(address, ex);
        }
        if (ci == null) {
            throw Messages.MESSAGES.noConduitInitiatorAvailableFor(address);
        }
        return ci;
    }

    private MessageObserver createMessageObserver(final Conduit c) {
        return new MessageObserver(){

            public void onMessage(Message inMessage) {
                LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)((InputStream)inMessage.getContent(InputStream.class)), (OutputStream)bout);
                    inMessage.getExchange().put(InputStream.class, (Object)bout.createInputStream());
                    Map inHeaders = (Map)inMessage.get((Object)Message.PROTOCOL_HEADERS);
                    inMessage.getExchange().put((Object)Message.PROTOCOL_HEADERS, (Object)inHeaders);
                    c.close(inMessage);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    private SOAPMessage readSoapMessage(Exchange exch) throws SOAPException {
        try {
            InputStream ins = (InputStream)exch.get(InputStream.class);
            Map inHeaders = (Map)exch.get((Object)Message.PROTOCOL_HEADERS);
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (inHeaders != null) {
                for (Map.Entry entry : inHeaders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    for (String value : (List)entry.getValue()) {
                        mimeHeaders.addHeader((String)entry.getKey(), value);
                    }
                }
            }
            if (ins == null) {
                return null;
            }
            if (ins.markSupported()) {
                ins.mark(1);
                int bytesRead = ins.read(new byte[1]);
                ins.reset();
                if (bytesRead == -1) {
                    return null;
                }
            } else if (ins.available() == 0) {
                return null;
            }
            MessageFactory msgFac = MessageFactory.newInstance((String)"Dynamic Protocol");
            return msgFac.createMessage(mimeHeaders, ins);
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.soapMessageCouldNotBeRead(ex);
        }
    }

    private void checkClosed() throws SOAPException {
        if (this.closed) {
            throw Messages.MESSAGES.cantSendMessagesOnClosedConnection();
        }
    }
}

