/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.jboss.as.messaging.HornetQDefaultCredentials;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;

public class HornetQSecurityManagerAS7
implements HornetQSecurityManager {
    private SecurityDomainContext securityDomainContext;
    private String defaultUser = null;
    private String defaultPassword = null;

    public HornetQSecurityManagerAS7(SecurityDomainContext sdc) {
        this.securityDomainContext = sdc;
        this.defaultUser = HornetQDefaultCredentials.getUsername();
        this.defaultPassword = HornetQDefaultCredentials.getPassword();
    }

    public boolean validateUser(String username, String password) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingLogger.ROOT_LOGGER.securityDomainContextNotSet();
        }
        return this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, new Subject());
    }

    public boolean validateUserAndRole(final String username, final String password, final Set<Role> roles, final CheckType checkType) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingLogger.ROOT_LOGGER.securityDomainContextNotSet();
        }
        final Subject subject = new Subject();
        boolean authenticated = this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, subject);
        if (authenticated) {
            authenticated = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    SecurityContext securityContext;
                    SimplePrincipal principal = new SimplePrincipal(username);
                    SecurityContext currentSecurityContext = SecurityContextAssociation.getSecurityContext();
                    if (currentSecurityContext == null) {
                        try {
                            securityContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)password, (Subject)subject, (String)HornetQSecurityManagerAS7.this.securityDomainContext.getAuthenticationManager().getSecurityDomain());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        securityContext = currentSecurityContext;
                        securityContext.getUtil().createSubjectInfo((Principal)principal, (Object)password, subject);
                    }
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    HashSet<SimplePrincipal> principals = new HashSet<SimplePrincipal>();
                    for (Role role : roles) {
                        if (!checkType.hasRole(role)) continue;
                        principals.add(new SimplePrincipal(role.getName()));
                    }
                    boolean authenticated = HornetQSecurityManagerAS7.this.securityDomainContext.getAuthorizationManager().doesUserHaveRole((Principal)new SimplePrincipal(username), principals);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)currentSecurityContext);
                    return authenticated;
                }
            });
        }
        return authenticated;
    }

    public void addUser(String s, String s1) {
    }

    public void removeUser(String s) {
    }

    public void addRole(String s, String s1) {
    }

    public void removeRole(String s, String s1) {
    }

    public void setDefaultUser(String s) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return false;
    }
}

