/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.connections.file.FileConnectionProvider;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.RealmEntity;
import org.keycloak.models.file.adapter.MigrationModelAdapter;
import org.keycloak.models.file.adapter.RealmAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.Provider;

public class FileRealmProvider
implements RealmProvider {
    private final KeycloakSession session;
    private FileConnectionProvider fcProvider;
    private final InMemoryModel inMemoryModel;

    public FileRealmProvider(KeycloakSession session, FileConnectionProvider fcProvider) {
        this.session = session;
        this.fcProvider = fcProvider;
        session.enlistForClose((Provider)this);
        this.inMemoryModel = fcProvider.getModel();
    }

    public void close() {
        this.fcProvider.sessionClosed(this.session);
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.inMemoryModel);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        if (this.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm " + name + " already exists.");
        }
        RealmEntity realmEntity = new RealmEntity();
        realmEntity.setName(name);
        realmEntity.setId(id);
        RealmAdapter realm = new RealmAdapter(this.session, realmEntity, this.inMemoryModel);
        this.inMemoryModel.putRealm(id, (RealmModel)realm);
        return realm;
    }

    public RealmModel getRealm(String id) {
        RealmModel model = this.inMemoryModel.getRealm(id);
        return model;
    }

    public List<RealmModel> getRealms() {
        return new ArrayList<RealmModel>(this.inMemoryModel.getRealms());
    }

    public RealmModel getRealmByName(String name) {
        RealmModel model = this.inMemoryModel.getRealmByName(name);
        return model;
    }

    public boolean removeRealm(String id) {
        return this.inMemoryModel.removeRealm(id);
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        return realm.getRoleById(id);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        return realm.getClientById(id);
    }
}

