/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.spi.workmanager;

import java.io.Serializable;

public final class Address
implements Comparable<Address>,
Serializable {
    private static final long serialVersionUID = 2L;
    private String workManagerId;
    private String workManagerName;
    private String transportId;

    public Address(String workManagerId, String workManagerName, String transportId) {
        if (workManagerId == null || workManagerId.trim().equals("")) {
            throw new IllegalArgumentException("WorkManagerId is undefined");
        }
        if (workManagerName == null || workManagerName.trim().equals("")) {
            throw new IllegalArgumentException("WorkManagerName is undefined");
        }
        this.workManagerId = workManagerId;
        this.workManagerName = workManagerName;
        this.transportId = transportId;
    }

    public String getWorkManagerId() {
        return this.workManagerId;
    }

    public String getWorkManagerName() {
        return this.workManagerName;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public int hashCode() {
        int result = 37;
        result += 7 * this.workManagerId.hashCode();
        result += 7 * this.workManagerName.hashCode();
        return result += this.transportId != null ? 7 * this.transportId.hashCode() : 7;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Address)) {
            return false;
        }
        Address a = (Address)o;
        if (!this.workManagerId.equals(a.workManagerId)) {
            return false;
        }
        if (!this.workManagerName.equals(a.workManagerName)) {
            return false;
        }
        return !(this.transportId != null ? !this.transportId.equals(a.transportId) : a.transportId != null);
    }

    @Override
    public int compareTo(Address a) {
        int compare = this.workManagerId.compareTo(a.getWorkManagerId());
        if (compare != 0) {
            return compare;
        }
        compare = this.workManagerName.compareTo(a.getWorkManagerName());
        if (compare != 0) {
            return compare;
        }
        if (this.transportId != null) {
            if (a.getTransportId() != null) {
                return this.transportId.compareTo(a.getTransportId());
            }
            return 1;
        }
        if (a.getTransportId() != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[workManagerId=").append(this.workManagerId);
        sb.append(" workManagerName=").append(this.workManagerName);
        sb.append(" transportId=").append(this.transportId);
        sb.append("]");
        return sb.toString();
    }
}

