/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.workflow.ServiceProviderSAMLWorkflow;

public class UndertowRedirectionHandler
extends ServiceProviderSAMLWorkflow.RedirectionHandler {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private HttpServerExchange httpServerExchange = null;

    public UndertowRedirectionHandler(HttpServerExchange httpServerExchange) {
        this.httpServerExchange = httpServerExchange;
    }

    public void sendPost(DestinationInfoHolder holder, HttpServletResponse response, boolean willSendRequest) throws IOException {
        String key = willSendRequest ? "SAMLRequest" : "SAMLResponse";
        String relayState = holder.getRelayState();
        String destination = holder.getDestination();
        String samlMessage = holder.getSamlMessage();
        if (destination == null) {
            throw logger.nullValueError("Destination is null");
        }
        response.setContentType("text/html");
        this.commonForPost();
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        if (willSendRequest) {
            builder.append("<TITLE>HTTP Post Binding (Request)</TITLE>");
        } else {
            builder.append("<TITLE>HTTP Post Binding Response (Response)</TITLE>");
        }
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + destination + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlMessage + "\"/>");
        if (StringUtil.isNotNull((String)relayState)) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + relayState + "\"/>");
        }
        builder.append("<NOSCRIPT>");
        builder.append("<P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue.</P>");
        builder.append("<INPUT TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("</NOSCRIPT>");
        builder.append("</FORM></BODY></HTML>");
        String str = builder.toString();
        logger.trace(str);
        OutputStream outputStream = this.httpServerExchange.getOutputStream();
        outputStream.write(str.getBytes("UTF-8"));
        outputStream.close();
    }

    public void sendRedirectForRequestor(String destination, HttpServletResponse response) throws IOException {
        this.commonForRedirect(destination);
        this.httpServerExchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "no-cache, no-store");
        response.sendRedirect(destination);
    }

    public void sendRedirectForResponder(String destination, HttpServletResponse response) throws IOException {
        this.commonForRedirect(destination);
        this.httpServerExchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate,private");
        response.sendRedirect(destination);
    }

    private void commonForRedirect(String destination) throws IOException {
        this.httpServerExchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "UTF-8");
        this.httpServerExchange.getResponseHeaders().put(Headers.PRAGMA, "no-cache");
        this.httpServerExchange.getResponseHeaders().put(Headers.LOCATION, destination);
    }

    private void commonForPost() {
        this.httpServerExchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "UTF-8");
        this.httpServerExchange.getResponseHeaders().put(Headers.PRAGMA, "no-cache");
        this.httpServerExchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "no-cache, no-store");
    }
}

