/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.marshalling.DynamicClassTable;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.marshalling.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.VersionedMarshallingConfiguration;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryServiceNameProvider;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.GroupServiceName;

public class ChannelCommandDispatcherFactoryBuilder
extends CommandDispatcherFactoryServiceNameProvider
implements Builder<CommandDispatcherFactory>,
Service<CommandDispatcherFactory>,
ChannelCommandDispatcherFactoryConfiguration,
VersionedMarshallingConfiguration {
    private static final int CURRENT_VERSION = 1;
    private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<JGroupsNodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ModuleIdentifier module;
    private final Map<Integer, MarshallingConfiguration> configurations = new HashMap<Integer, MarshallingConfiguration>();
    private volatile MarshallingContext marshallingContext = null;
    private volatile ChannelCommandDispatcherFactory factory = null;
    private volatile long timeout = TimeUnit.MINUTES.toMillis(1L);

    public ChannelCommandDispatcherFactoryBuilder(String group, ModuleIdentifier module) {
        super(group);
        this.module = module;
    }

    public ServiceBuilder<CommandDispatcherFactory> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(GroupServiceName.NODE_FACTORY.getServiceName(this.group), JGroupsNodeFactory.class, this.nodeFactory).addDependency(ChannelServiceName.CONNECTOR.getServiceName(this.group), Channel.class, this.channel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.group), ChannelFactory.class, this.channelFactory).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ChannelCommandDispatcherFactoryBuilder timeout(long value, TimeUnit unit) {
        this.timeout = unit.toMillis(value);
        return this;
    }

    public void start(StartContext context) throws StartException {
        ModuleLoader loader = (ModuleLoader)this.loader.getValue();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
        try {
            Module module = loader.loadModule(this.module);
            configuration.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
            this.configurations.put(1, configuration);
            this.marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)this, (ClassLoader)module.getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        this.factory = new ChannelCommandDispatcherFactory(this);
    }

    public void stop(StopContext context) {
        try {
            this.factory.close();
            this.factory = null;
            this.marshallingContext = null;
        }
        finally {
            this.configurations.clear();
        }
    }

    public CommandDispatcherFactory getValue() {
        return this.factory;
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration configuration = this.configurations.get(version);
        if (configuration == null) {
            throw new IllegalArgumentException(Integer.toString(version));
        }
        return configuration;
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public JGroupsNodeFactory getNodeFactory() {
        return (JGroupsNodeFactory)this.nodeFactory.getValue();
    }

    @Override
    public MarshallingContext getMarshallingContext() {
        return this.marshallingContext;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.channelFactory.getValue();
    }
}

