/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class SamlProtocolUtils {
    public static void verifyDocumentSignature(ClientModel client, Document document) throws VerificationException {
        SamlClient samlClient = new SamlClient(client);
        if (!samlClient.requiresClientSignature()) {
            return;
        }
        PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
        SamlProtocolUtils.verifyDocumentSignature(document, publicKey);
    }

    public static void verifyDocumentSignature(Document document, PublicKey publicKey) throws VerificationException {
        SAML2Signature saml2Signature = new SAML2Signature();
        try {
            if (!saml2Signature.validate(document, publicKey)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    public static PublicKey getSignatureValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(new SamlClient(client).getClientSigningCertificate());
    }

    public static PublicKey getEncryptionValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.encryption.certificate");
    }

    public static PublicKey getPublicKey(ClientModel client, String attribute) throws VerificationException {
        String certPem = client.getAttribute(attribute);
        return SamlProtocolUtils.getPublicKey(certPem);
    }

    private static PublicKey getPublicKey(String certPem) throws VerificationException {
        if (certPem == null) {
            throw new VerificationException("Client does not have a public key.");
        }
        X509Certificate cert = null;
        try {
            cert = PemUtils.decodeCertificate((String)certPem);
        }
        catch (Exception e) {
            throw new VerificationException("Could not decode cert", (Throwable)e);
        }
        return cert.getPublicKey();
    }

    public static void verifyRedirectSignature(PublicKey publicKey, UriInfo uriInformation, String paramKey) throws VerificationException {
        MultivaluedMap encodedParams = uriInformation.getQueryParameters(false);
        String request = (String)encodedParams.getFirst((Object)paramKey);
        String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
        String signature = (String)encodedParams.getFirst((Object)"Signature");
        String decodedAlgorithm = (String)uriInformation.getQueryParameters(true).getFirst((Object)"SigAlg");
        if (request == null) {
            throw new VerificationException("SAM was null");
        }
        if (algorithm == null) {
            throw new VerificationException("SigAlg was null");
        }
        if (signature == null) {
            throw new VerificationException("Signature was null");
        }
        UriBuilder builder = UriBuilder.fromPath((String)"/").queryParam(paramKey, new Object[]{request});
        if (encodedParams.containsKey((Object)"RelayState")) {
            builder.queryParam("RelayState", new Object[]{encodedParams.getFirst((Object)"RelayState")});
        }
        builder.queryParam("SigAlg", new Object[]{algorithm});
        String rawQuery = builder.build(new Object[0]).getRawQuery();
        try {
            byte[] decodedSignature = RedirectBindingUtil.urlBase64Decode((String)signature);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getFromXmlMethod((String)decodedAlgorithm);
            Signature validator = signatureAlgorithm.createSignature();
            validator.initVerify(publicKey);
            validator.update(rawQuery.getBytes("UTF-8"));
            if (!validator.verify(decodedSignature)) {
                throw new VerificationException("Invalid query param signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }
}

