/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class TransactionStore {
    private static final String LAST_TRANSACTION_ID = "lastTransactionId";
    private static final int MAX_UNSAVED_PAGES = 4096;
    final MVStore store;
    final MVMap<Long, Object[]> preparedTransactions;
    final MVMap<long[], Object[]> undoLog;
    long lockTimeout;
    private final MVMap<String, String> settings;
    private final DataType dataType;
    private long lastTransactionIdStored;
    private long lastTransactionId;
    private long firstOpenTransaction = -1L;

    public TransactionStore(MVStore mVStore) {
        this(mVStore, new ObjectDataType());
    }

    public TransactionStore(MVStore mVStore, DataType dataType) {
        this.store = mVStore;
        this.dataType = dataType;
        this.settings = mVStore.openMap("settings");
        this.preparedTransactions = mVStore.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType versionedValueType = new VersionedValueType(dataType);
        ArrayType arrayType = new ArrayType(new DataType[]{new ObjectDataType(), new ObjectDataType(), dataType, versionedValueType});
        MVMap.Builder builder = new MVMap.Builder().valueType(arrayType);
        this.undoLog = mVStore.openMap("undoLog", builder);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        Long l;
        String string = this.settings.get(LAST_TRANSACTION_ID);
        if (string != null) {
            this.lastTransactionIdStored = this.lastTransactionId = Long.parseLong(string);
        }
        if ((l = this.preparedTransactions.lastKey()) != null && l > this.lastTransactionId) {
            throw DataUtils.newIllegalStateException(100, "Last transaction not stored", new Object[0]);
        }
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            if (this.undoLog.size() > 0) {
                long[] lArray = this.undoLog.firstKey();
                this.firstOpenTransaction = lArray[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getOpenTransactions() {
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            ArrayList<Transaction> arrayList = New.arrayList();
            long[] lArray = this.undoLog.firstKey();
            while (lArray != null) {
                String string;
                int n;
                long l = lArray[0];
                long[] lArray2 = new long[]{l, Long.MAX_VALUE};
                lArray = this.undoLog.floorKey(lArray2);
                long l2 = lArray[1] + 1L;
                Object[] objectArray = this.preparedTransactions.get(l);
                if (objectArray == null) {
                    lArray[1] = 0L;
                    n = this.undoLog.containsKey(lArray) ? 1 : 3;
                    string = null;
                } else {
                    n = (Integer)objectArray[0];
                    string = (String)objectArray[1];
                }
                Transaction transaction = new Transaction(this, l, n, string, l2);
                arrayList.add(transaction);
                lArray = this.undoLog.higherKey(lArray2);
            }
            return arrayList;
        }
    }

    public synchronized void close() {
        this.settings.put(LAST_TRANSACTION_ID, "" + this.lastTransactionId);
        this.store.commit();
    }

    public synchronized Transaction begin() {
        long l = this.lastTransactionId++;
        if (this.lastTransactionId > this.lastTransactionIdStored) {
            this.lastTransactionIdStored += 64L;
            this.settings.put(LAST_TRANSACTION_ID, "" + this.lastTransactionIdStored);
        }
        int n = 1;
        return new Transaction(this, l, n, null, 0L);
    }

    private void commitIfNeeded() {
        if (this.store.getUnsavedPageCount() > 4096) {
            this.store.commit();
            this.store.store();
        }
    }

    synchronized void storeTransaction(Transaction transaction) {
        if (transaction.getStatus() == 2 || transaction.getName() != null) {
            Object[] objectArray = new Object[]{transaction.getStatus(), transaction.getName()};
            this.preparedTransactions.put(transaction.getId(), objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Transaction transaction, long l, int n, int n2, Object object, Object object2) {
        this.commitIfNeeded();
        long[] lArray = new long[]{transaction.getId(), l};
        Object[] objectArray = new Object[]{n, n2, object, object2};
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            this.undoLog.put(lArray, objectArray);
        }
        if (this.firstOpenTransaction == -1L || transaction.getId() < this.firstOpenTransaction) {
            this.firstOpenTransaction = transaction.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction transaction, long l) {
        if (this.store.isClosed()) {
            return;
        }
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            transaction.setStatus(3);
            for (long i = 0L; i < l; ++i) {
                Object object;
                int n;
                MVMap<Object, VersionedValue> mVMap2;
                VersionedValue versionedValue;
                this.commitIfNeeded();
                long[] lArray = new long[]{transaction.getId(), i};
                Object[] objectArray = this.undoLog.get(lArray);
                if (objectArray == null) {
                    if ((lArray = this.undoLog.ceilingKey(lArray)) == null || lArray[0] != transaction.getId()) break;
                    i = lArray[1] - 1L;
                    continue;
                }
                int n2 = (Integer)objectArray[0];
                if (n2 == 0 && (versionedValue = (mVMap2 = this.openMap(n = ((Integer)objectArray[1]).intValue())).get(object = objectArray[2])) != null && versionedValue.value == null) {
                    mVMap2.remove(object);
                }
                this.undoLog.remove(lArray);
            }
        }
        this.endTransaction(transaction);
    }

    private synchronized MVMap<Object, VersionedValue> openMap(int n) {
        MVMap<String, String> mVMap = this.store.getMetaMap();
        String string = (String)mVMap.get("map." + n);
        if (string == null) {
            return null;
        }
        String string2 = DataUtils.parseMap(string).get("name");
        VersionedValueType versionedValueType = new VersionedValueType(this.dataType);
        MVMap.Builder builder = new MVMap.Builder().keyType(this.dataType).valueType(versionedValueType);
        Object m = this.store.openMap(string2, builder);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTransactionOpen(long l) {
        if (l < this.firstOpenTransaction) {
            return false;
        }
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            long[] lArray;
            if (this.firstOpenTransaction == -1L) {
                if (this.undoLog.size() == 0) {
                    return false;
                }
                lArray = this.undoLog.firstKey();
                if (lArray == null) {
                    return false;
                }
                this.firstOpenTransaction = lArray[0];
            }
            if (this.firstOpenTransaction == l) {
                return true;
            }
            lArray = new long[]{l, -1L};
            return (lArray = this.undoLog.higherKey(lArray)) != null && lArray[0] == l;
        }
    }

    synchronized void endTransaction(Transaction transaction) {
        if (transaction.getStatus() == 2) {
            this.preparedTransactions.remove(transaction.getId());
        }
        transaction.setStatus(0);
        if (transaction.getId() == this.firstOpenTransaction) {
            this.firstOpenTransaction = -1L;
        }
        if (this.store.getWriteDelay() == 0) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackTo(Transaction transaction, long l, long l2) {
        MVMap<long[], Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            for (long i = l - 1L; i >= l2; --i) {
                this.commitIfNeeded();
                long[] lArray = new long[]{transaction.getId(), i};
                Object[] objectArray = this.undoLog.get(lArray);
                if (objectArray == null) {
                    if ((lArray = this.undoLog.floorKey(lArray)) == null || lArray[0] != transaction.getId()) break;
                    i = lArray[1] + 1L;
                    continue;
                }
                int n = (Integer)objectArray[1];
                MVMap<Object, VersionedValue> mVMap2 = this.openMap(n);
                if (mVMap2 != null) {
                    Object object = objectArray[2];
                    VersionedValue versionedValue = (VersionedValue)objectArray[3];
                    if (versionedValue == null) {
                        mVMap2.remove(object);
                    } else {
                        mVMap2.put(object, versionedValue);
                    }
                }
                this.undoLog.remove(lArray);
            }
        }
    }

    Iterator<Change> getChanges(final Transaction transaction, final long l, final long l2) {
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = l - 1L;
                this.fetchNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNext() {
                MVMap<long[], Object[]> mVMap = TransactionStore.this.undoLog;
                synchronized (mVMap) {
                    while (this.logId >= l2) {
                        long[] lArray = new long[]{transaction.getId(), this.logId--};
                        Object[] objectArray = TransactionStore.this.undoLog.get(lArray);
                        if (objectArray == null) {
                            if ((lArray = TransactionStore.this.undoLog.floorKey(lArray)) == null || lArray[0] != transaction.getId()) break;
                            this.logId = lArray[1];
                            continue;
                        }
                        int n = (Integer)objectArray[1];
                        MVMap<String, String> mVMap2 = TransactionStore.this.store.getMetaMap();
                        String string = (String)mVMap2.get("map." + n);
                        if (string == null) continue;
                        this.current = new Change();
                        this.current.mapName = DataUtils.parseMap(string).get("name");
                        this.current.key = objectArray[2];
                        VersionedValue versionedValue = (VersionedValue)objectArray[3];
                        this.current.value = versionedValue == null ? null : versionedValue.value;
                        return;
                    }
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Change next() {
                if (this.current == null) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change change = this.current;
                this.fetchNext();
                return change;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] dataTypeArray) {
            this.arrayLength = dataTypeArray.length;
            this.elementTypes = dataTypeArray;
        }

        @Override
        public int getMemory(Object object) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                n += dataType.getMemory(object2);
            }
            return n;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                int n = dataType.compare(objectArray[i], objectArray2[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        @Override
        public ByteBuffer write(ByteBuffer byteBuffer, Object object) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) {
                    byteBuffer.put((byte)0);
                    continue;
                }
                byteBuffer.put((byte)1);
                byteBuffer = dataType.write(byteBuffer, object2);
            }
            return byteBuffer;
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            Object[] objectArray = new Object[this.arrayLength];
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                if (byteBuffer.get() != 1) continue;
                objectArray[i] = dataType.read(byteBuffer);
            }
            return objectArray;
        }
    }

    public static class VersionedValueType
    implements DataType {
        private final DataType valueType;

        VersionedValueType(DataType dataType) {
            this.valueType = dataType;
        }

        @Override
        public int getMemory(Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            return this.valueType.getMemory(versionedValue.value) + 16;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            VersionedValue versionedValue = (VersionedValue)object;
            VersionedValue versionedValue2 = (VersionedValue)object2;
            long l = versionedValue.transactionId - versionedValue2.transactionId;
            if (l == 0L && (l = versionedValue.logId - versionedValue2.logId) == 0L) {
                return this.valueType.compare(versionedValue.value, versionedValue2.value);
            }
            return Long.signum(l);
        }

        @Override
        public ByteBuffer write(ByteBuffer byteBuffer, Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            DataUtils.writeVarLong(byteBuffer, versionedValue.transactionId);
            DataUtils.writeVarLong(byteBuffer, versionedValue.logId);
            if (versionedValue.value == null) {
                byteBuffer.put((byte)0);
            } else {
                byteBuffer.put((byte)1);
                byteBuffer = this.valueType.write(byteBuffer, versionedValue.value);
            }
            return byteBuffer;
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            VersionedValue versionedValue = new VersionedValue();
            versionedValue.transactionId = DataUtils.readVarLong(byteBuffer);
            versionedValue.logId = DataUtils.readVarLong(byteBuffer);
            if (byteBuffer.get() == 1) {
                versionedValue.value = this.valueType.read(byteBuffer);
            }
            return versionedValue;
        }
    }

    static class VersionedValue {
        public long transactionId;
        public long logId;
        public Object value;

        VersionedValue() {
        }
    }

    public static class TransactionMap<K, V> {
        final MVMap<K, VersionedValue> map;
        private Transaction transaction;
        private final int mapId;
        private long readLogId = Long.MAX_VALUE;

        TransactionMap(Transaction transaction, String string, DataType dataType, DataType dataType2) {
            this.transaction = transaction;
            VersionedValueType versionedValueType = new VersionedValueType(dataType2);
            MVMap.Builder builder = new MVMap.Builder().keyType(dataType).valueType(versionedValueType);
            this.map = transaction.store.store.openMap(string, builder);
            this.mapId = this.map.getId();
        }

        private TransactionMap(Transaction transaction, MVMap<K, VersionedValue> mVMap, int n) {
            this.transaction = transaction;
            this.map = mVMap;
            this.mapId = n;
        }

        public void setSavepoint(long l) {
            this.readLogId = l;
        }

        public TransactionMap<K, V> getInstance(Transaction transaction, long l) {
            TransactionMap<K, V> transactionMap = new TransactionMap<K, V>(transaction, this.map, this.mapId);
            transactionMap.setSavepoint(l);
            return transactionMap;
        }

        public long getSize() {
            long l = 0L;
            Cursor<Object> cursor = this.map.keyIterator(null);
            while (cursor.hasNext()) {
                K k = cursor.next();
                if (this.get(k) == null) continue;
                ++l;
            }
            return l;
        }

        public V remove(K k) {
            return this.set(k, null);
        }

        public V put(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.set(k, v);
        }

        private V set(K k, V v) {
            this.transaction.checkNotClosed();
            long l = 0L;
            while (true) {
                V v2 = this.get(k);
                boolean bl = this.trySet(k, v, false);
                if (bl) {
                    return v2;
                }
                long l2 = this.transaction.store.lockTimeout;
                if (l2 == 0L) {
                    throw DataUtils.newIllegalStateException(101, "Lock timeout", new Object[0]);
                }
                if (l == 0L) {
                    l = System.currentTimeMillis();
                    continue;
                }
                long l3 = System.currentTimeMillis() - l;
                if (l3 > l2) {
                    throw DataUtils.newIllegalStateException(101, "Lock timeout", new Object[0]);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public boolean tryRemove(K k) {
            return this.trySet(k, null, false);
        }

        public boolean tryPut(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.trySet(k, v, false);
        }

        public boolean trySet(K k, V v, boolean bl) {
            VersionedValue versionedValue;
            VersionedValue versionedValue2 = this.map.get(k);
            if (bl && !this.map.areValuesEqual(versionedValue = this.getValue(k, this.readLogId), versionedValue2)) {
                long l = versionedValue2.transactionId;
                if (l == this.transaction.transactionId) {
                    if (v == null) {
                        return true;
                    }
                    if (versionedValue2.value != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            int n = versionedValue2 == null || versionedValue2.value == null ? (v == null ? 2 : 1) : (v == null ? 0 : 2);
            VersionedValue versionedValue3 = new VersionedValue();
            versionedValue3.transactionId = this.transaction.transactionId;
            versionedValue3.logId = this.transaction.logId;
            versionedValue3.value = v;
            if (versionedValue2 == null) {
                VersionedValue versionedValue4 = this.map.putIfAbsent(k, versionedValue3);
                if (versionedValue4 == null) {
                    this.transaction.log(n, this.mapId, k, versionedValue2);
                    return true;
                }
                return false;
            }
            long l = versionedValue2.transactionId;
            if (l == this.transaction.transactionId) {
                if (this.map.replace(k, versionedValue2, versionedValue3)) {
                    this.transaction.log(n, this.mapId, k, versionedValue2);
                    return true;
                }
                return false;
            }
            boolean bl2 = this.transaction.store.isTransactionOpen(l);
            if (!bl2) {
                if (this.map.replace(k, versionedValue2, versionedValue3)) {
                    this.transaction.log(n, this.mapId, k, versionedValue2);
                    return true;
                }
                return false;
            }
            return false;
        }

        public V get(K k) {
            return this.get(k, this.readLogId);
        }

        public V getLatest(K k) {
            return this.get(k, Long.MAX_VALUE);
        }

        public boolean containsKey(K k) {
            return this.get(k) != null;
        }

        public V get(K k, long l) {
            this.transaction.checkNotClosed();
            VersionedValue versionedValue = this.getValue(k, l);
            return (V)(versionedValue == null ? null : versionedValue.value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionedValue getValue(K k, long l) {
            VersionedValue versionedValue = this.map.get(k);
            while (versionedValue != null) {
                long l2 = versionedValue.transactionId;
                long l3 = versionedValue.logId;
                if (l2 == this.transaction.transactionId && l3 < l) {
                    return versionedValue;
                }
                boolean bl = this.transaction.store.isTransactionOpen(l2);
                if (!bl) {
                    return versionedValue;
                }
                long[] lArray = new long[]{l2, l3};
                MVMap<long[], Object[]> mVMap = this.transaction.store.undoLog;
                synchronized (mVMap) {
                    Object[] objectArray = this.transaction.store.undoLog.get(lArray);
                    versionedValue = (VersionedValue)objectArray[3];
                }
            }
            return null;
        }

        public void renameMap(String string) {
            this.map.renameMap(string);
        }

        public boolean isClosed() {
            return this.map.isClosed();
        }

        public void removeMap() {
            this.map.removeMap();
        }

        public void clear() {
            this.map.clear();
        }

        public K firstKey() {
            Iterator<Object> iterator = this.keyIterator(null);
            return (K)(iterator.hasNext() ? iterator.next() : null);
        }

        public K lastKey() {
            K k = this.map.lastKey();
            while (k != null) {
                if (this.get(k) != null) {
                    return k;
                }
                k = this.map.lowerKey(k);
            }
            return null;
        }

        public K getLatestCeilingKey(K k) {
            Cursor<K> cursor = this.map.keyIterator(k);
            while (cursor.hasNext()) {
                k = cursor.next();
                if (this.get(k, Long.MAX_VALUE) == null) continue;
                return k;
            }
            return null;
        }

        public K ceilingKey(K k) {
            Cursor<K> cursor = this.map.keyIterator(k);
            while (cursor.hasNext()) {
                k = cursor.next();
                if (this.get(k) == null) continue;
                return k;
            }
            return null;
        }

        public K higherKey(K k) {
            return this.map.higherKey(k);
        }

        public K lowerKey(K k) {
            return this.map.lowerKey(k);
        }

        public Iterator<K> keyIterator(final K k) {
            return new Iterator<K>(){
                private final Cursor<K> cursor;
                private K current;
                {
                    this.cursor = TransactionMap.this.map.keyIterator(k);
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        this.current = this.cursor.next();
                        if (!TransactionMap.this.containsKey(this.current)) continue;
                        return;
                    }
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public K next() {
                    Object k2 = this.current;
                    this.fetchNext();
                    return k2;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Transaction getTransaction() {
            return this.transaction;
        }
    }

    public static class Transaction {
        public static final int STATUS_CLOSED = 0;
        public static final int STATUS_OPEN = 1;
        public static final int STATUS_PREPARED = 2;
        public static final int STATUS_COMMITTING = 3;
        static final int OP_REMOVE = 0;
        static final int OP_ADD = 1;
        static final int OP_SET = 2;
        final TransactionStore store;
        final long transactionId;
        long logId;
        private int status;
        private String name;

        Transaction(TransactionStore transactionStore, long l, int n, String string, long l2) {
            this.store = transactionStore;
            this.transactionId = l;
            this.status = n;
            this.name = string;
            this.logId = l2;
        }

        public long getId() {
            return this.transactionId;
        }

        public int getStatus() {
            return this.status;
        }

        void setStatus(int n) {
            this.status = n;
        }

        public void setName(String string) {
            this.checkNotClosed();
            this.name = string;
            this.store.storeTransaction(this);
        }

        public String getName() {
            return this.name;
        }

        public long setSavepoint() {
            this.checkNotClosed();
            return this.logId;
        }

        void log(int n, int n2, Object object, Object object2) {
            this.store.log(this, this.logId++, n, n2, object, object2);
        }

        public <K, V> TransactionMap<K, V> openMap(String string) {
            this.checkNotClosed();
            return new TransactionMap(this, string, new ObjectDataType(), new ObjectDataType());
        }

        public <K, V> TransactionMap<K, V> openMap(String string, MVMap.Builder<K, V> builder) {
            DataType dataType;
            this.checkNotClosed();
            DataType dataType2 = builder.getKeyType();
            if (dataType2 == null) {
                dataType2 = new ObjectDataType();
            }
            if ((dataType = builder.getValueType()) == null) {
                dataType = new ObjectDataType();
            }
            return new TransactionMap(this, string, dataType2, dataType);
        }

        public void prepare() {
            this.checkNotClosed();
            this.status = 2;
            this.store.storeTransaction(this);
        }

        public void commit() {
            this.checkNotClosed();
            this.store.commit(this, this.logId);
        }

        public void rollbackToSavepoint(long l) {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, l);
            this.logId = l;
        }

        public void rollback() {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, 0L);
            this.store.endTransaction(this);
        }

        public Iterator<Change> getChanges(long l) {
            return this.store.getChanges(this, this.logId, l);
        }

        void checkNotClosed() {
            if (this.status == 0) {
                throw DataUtils.newIllegalStateException(4, "Transaction is closed", new Object[0]);
            }
        }
    }

    public static class Change {
        public String mapName;
        public Object key;
        public Object value;
    }
}

