/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.Random;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LocalEJBReceiverPreferringDeploymentNodeSelector
implements DeploymentNodeSelector {
    private final String localNodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);

    public String selectNode(String[] eligibleNodes, String appName, String moduleName, String distinctName) {
        if (eligibleNodes.length == 1) {
            return eligibleNodes[0];
        }
        for (String eligibleNode : eligibleNodes) {
            if (!this.localNodeName.equals(eligibleNode)) continue;
            EjbLogger.REMOTE_LOGGER.debugf("Selected local node %s for [app: %s, module: %s,  distinctname: %s]", new Object[]{this.localNodeName, appName, moduleName, distinctName});
            return eligibleNode;
        }
        Random random = new Random();
        int randomSelection = random.nextInt(eligibleNodes.length);
        return eligibleNodes[randomSelection];
    }
}

