/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.Collections;
import java.util.List;
import javax.naming.AuthenticationException;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.UserModel;

public abstract class AbstractLDAPFederationMapper {
    protected final UserFederationMapperModel mapperModel;
    protected final LDAPFederationProvider ldapProvider;
    protected final RealmModel realm;

    public AbstractLDAPFederationMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm) {
        this.mapperModel = mapperModel;
        this.ldapProvider = ldapProvider;
        this.realm = realm;
    }

    public UserFederationSyncResult syncDataFromFederationProviderToKeycloak() {
        return new UserFederationSyncResult();
    }

    public UserFederationSyncResult syncDataFromKeycloakToFederationProvider() {
        return new UserFederationSyncResult();
    }

    public abstract void beforeLDAPQuery(LDAPQuery var1);

    public abstract UserModel proxy(LDAPObject var1, UserModel var2);

    public abstract void onRegisterUserToLDAP(LDAPObject var1, UserModel var2);

    public abstract void onImportUserFromLDAP(LDAPObject var1, UserModel var2, boolean var3);

    public List<UserModel> getGroupMembers(GroupModel group, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public boolean onAuthenticationFailure(LDAPObject ldapUser, UserModel user, AuthenticationException ldapException) {
        return false;
    }

    public static boolean parseBooleanParameter(UserFederationMapperModel mapperModel, String paramName) {
        String paramm = (String)mapperModel.getConfig().get(paramName);
        return Boolean.parseBoolean(paramm);
    }

    public LDAPFederationProvider getLdapProvider() {
        return this.ldapProvider;
    }

    public RealmModel getRealm() {
        return this.realm;
    }
}

