/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import javax.batch.api.chunk.ItemReader;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Properties;
import org.jberet.job.model.Script;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.ScriptArtifactBase;

final class ScriptItemReader
extends ScriptArtifactBase
implements ItemReader {
    private final Invocable invocable;

    public ScriptItemReader(Script script, Properties artifactProperties, StepContextImpl stepContext) throws ScriptException {
        super(script, artifactProperties, stepContext);
        if (!(this.engine instanceof Invocable)) {
            throw BatchMessages.MESSAGES.scriptNotInvocable(this.scriptContent);
        }
        this.invocable = (Invocable)((Object)this.engine);
        if (this.compiledScript != null) {
            this.compiledScript.eval();
        } else {
            this.engine.eval(this.scriptContent);
        }
    }

    public void open(Serializable checkpoint) throws Exception {
        try {
            this.invocable.invokeFunction(this.getFunctionName("open"), checkpoint);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        try {
            this.invocable.invokeFunction(this.getFunctionName("close"), new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Object readItem() throws Exception {
        return this.invocable.invokeFunction(this.getFunctionName("readItem"), new Object[0]);
    }

    public Serializable checkpointInfo() throws Exception {
        try {
            return (Serializable)this.invocable.invokeFunction(this.getFunctionName("checkpointInfo"), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

