/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class BulkGetOperation<K, V>
extends RetryOnFailureOperation<Map<K, V>> {
    private final int entryCount;

    public BulkGetOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, int flags, int entryCount) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.entryCount = entryCount;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected Map<K, V> executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)25);
        transport.writeVInt(this.entryCount);
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        HashMap result = new HashMap();
        while (transport.readByte() == 1) {
            Object key = this.codec.readUnmarshallByteArray(transport, status);
            Object value = this.codec.readUnmarshallByteArray(transport, status);
            result.put(key, value);
        }
        return result;
    }
}

