/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.util;

import java.io.File;
import org.jboss.as.cli.parsing.UnresolvedExpressionException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CLIExpressionResolver {
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final String ENV_PREFIX = "env.";
    private static final int INITIAL = 0;
    private static final int DOLLAR = 1;

    public static String resolve(String input) throws UnresolvedExpressionException {
        return CLIExpressionResolver.resolve(input, true);
    }

    public static String resolveOrOriginal(String input) {
        try {
            return CLIExpressionResolver.resolve(input, true);
        }
        catch (UnresolvedExpressionException e) {
            return input;
        }
    }

    private static String resolve(String input, boolean exceptionIfNotResolved) throws UnresolvedExpressionException {
        boolean state = false;
        int i = 0;
        while (i < input.length()) {
            char c;
            if ((c = input.charAt(i++)) == '$') {
                if (state) {
                    state = false;
                    StringBuilder buf = new StringBuilder(input.length() - 1);
                    buf.append(input.substring(0, --i));
                    if (i + 1 < input.length()) {
                        buf.append(input.substring(i + 1));
                    }
                    input = buf.toString();
                    continue;
                }
                state = true;
                continue;
            }
            if (c != '{' || !state) continue;
            state = false;
            String[] inputRef = new String[]{input};
            if (i - 2 != CLIExpressionResolver.resolveProperty2(inputRef, i - 2, exceptionIfNotResolved)) continue;
            input = inputRef[0];
            i -= 2;
        }
        return input;
    }

    public static String resolveProperty(String input, int location, boolean exceptionIfNotResolved) throws UnresolvedExpressionException {
        String[] inputRef = new String[]{input};
        if (location == CLIExpressionResolver.resolveProperty2(inputRef, location, exceptionIfNotResolved)) {
            return inputRef[0];
        }
        return input;
    }

    private static int resolveProperty2(String[] inputRef, int location, boolean exceptionIfNotResolved) throws UnresolvedExpressionException {
        int nestingLevel = 1;
        boolean state = false;
        StringBuilder expression = new StringBuilder();
        int i = location + 2;
        block5: while (i < inputRef[0].length()) {
            char c = inputRef[0].charAt(i++);
            switch (c) {
                case '$': {
                    if (state) {
                        expression.append(c);
                        state = false;
                        continue block5;
                    }
                    state = true;
                    continue block5;
                }
                case '{': {
                    if (state) {
                        state = false;
                        if (expression.length() > 0 && expression.charAt(expression.length() - 1) == ':') {
                            expression.append("${");
                            ++nestingLevel;
                            continue block5;
                        }
                        i = CLIExpressionResolver.resolveProperty2(inputRef, i - 2, exceptionIfNotResolved);
                        continue block5;
                    }
                    expression.append(c);
                    continue block5;
                }
                case '}': {
                    if (state) {
                        expression.append('$');
                    }
                    if (--nestingLevel > 0) {
                        state = false;
                        expression.append(c);
                        continue block5;
                    }
                    String propName = expression.toString();
                    String resolved = CLIExpressionResolver.resolveKey(propName);
                    if (resolved != null) {
                        String input = inputRef[0];
                        StringBuilder buf = new StringBuilder(input.length() - i + location + resolved.length());
                        buf.append(input.substring(0, location)).append(resolved);
                        if (i < input.length()) {
                            buf.append(input.substring(i));
                        }
                        inputRef[0] = buf.toString();
                        return location;
                    }
                    if (exceptionIfNotResolved) {
                        throw new UnresolvedExpressionException(inputRef[0].substring(location, i), "Unrecognized system property " + propName);
                    }
                    return i;
                }
            }
            if (state) {
                state = false;
                expression.append('$');
            }
            expression.append(c);
        }
        return i;
    }

    private static String resolveKey(String key) {
        String value = null;
        if (FILE_SEPARATOR_ALIAS.equals(key)) {
            value = FILE_SEPARATOR;
        } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
            value = PATH_SEPARATOR;
        } else {
            value = WildFlySecurityManager.getPropertyPrivileged(key, null);
            if (value == null && key.startsWith(ENV_PREFIX)) {
                value = System.getenv(key.substring(4));
            }
            if (value == null) {
                int colon = key.indexOf(58);
                if (colon > 0) {
                    String realKey = key.substring(0, colon);
                    value = WildFlySecurityManager.getPropertyPrivileged(realKey, null);
                    if (value == null && realKey.startsWith(ENV_PREFIX)) {
                        value = System.getenv(realKey.substring(4));
                    }
                    if (value == null && (value = CLIExpressionResolver.resolveCompositeKey(realKey)) == null) {
                        value = key.substring(colon + 1);
                    }
                } else {
                    value = CLIExpressionResolver.resolveCompositeKey(key);
                }
            }
        }
        return value;
    }

    private static String resolveCompositeKey(String key) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            String key2;
            String key1;
            if (comma > 0 && (value = WildFlySecurityManager.getPropertyPrivileged(key1 = key.substring(0, comma), null)) == null && key1.startsWith(ENV_PREFIX)) {
                value = System.getenv(key1.substring(4));
            }
            if (value == null && comma < key.length() - 1 && (value = WildFlySecurityManager.getPropertyPrivileged(key2 = key.substring(comma + 1), null)) == null && key2.startsWith(ENV_PREFIX)) {
                value = System.getenv(key2.substring(4));
            }
        }
        return value;
    }
}

