/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

public abstract class Alphabet {
    final boolean littleEndian;

    Alphabet(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public abstract int encode(int var1);

    public abstract int decode(int var1);

    public static abstract class Base32Alphabet
    extends Alphabet {
        public static final Base32Alphabet STANDARD = new Base32Alphabet(false){

            @Override
            public int encode(int val) {
                if (val <= 25) {
                    return 65 + val;
                }
                assert (val < 32);
                return 50 + val - 26;
            }

            @Override
            public int decode(int codePoint) {
                if (65 <= codePoint && codePoint <= 90) {
                    return codePoint - 65;
                }
                if (50 <= codePoint && codePoint <= 55) {
                    return codePoint - 50 + 26;
                }
                return -1;
            }
        };

        Base32Alphabet(boolean littleEndian) {
            super(littleEndian);
        }

        @Override
        public abstract int encode(int var1);

        @Override
        public abstract int decode(int var1);
    }

    public static abstract class Base64Alphabet
    extends Alphabet {
        public static final Base64Alphabet STANDARD = new Base64Alphabet(false){

            @Override
            public int encode(int val) {
                if (val <= 25) {
                    return 65 + val;
                }
                if (val <= 51) {
                    return 97 + val - 26;
                }
                if (val <= 61) {
                    return 48 + val - 52;
                }
                if (val == 62) {
                    return 43;
                }
                assert (val == 63);
                return 47;
            }

            @Override
            public int decode(int codePoint) throws IllegalArgumentException {
                if (65 <= codePoint && codePoint <= 90) {
                    return codePoint - 65;
                }
                if (97 <= codePoint && codePoint <= 122) {
                    return codePoint - 97 + 26;
                }
                if (48 <= codePoint && codePoint <= 57) {
                    return codePoint - 48 + 52;
                }
                if (codePoint == 43) {
                    return 62;
                }
                if (codePoint == 47) {
                    return 63;
                }
                return -1;
            }
        };
        public static final Base64Alphabet MOD_CRYPT = new Base64Alphabet(false){

            @Override
            public int encode(int val) {
                if (val == 0) {
                    return 46;
                }
                if (val == 1) {
                    return 47;
                }
                if (val <= 11) {
                    return 48 + val - 2;
                }
                if (val <= 37) {
                    return 65 + val - 12;
                }
                assert (val < 64);
                return 97 + val - 38;
            }

            @Override
            public int decode(int codePoint) throws IllegalArgumentException {
                if (codePoint == 46) {
                    return 0;
                }
                if (codePoint == 47) {
                    return 1;
                }
                if (48 <= codePoint && codePoint <= 57) {
                    return codePoint - 48 + 2;
                }
                if (65 <= codePoint && codePoint <= 90) {
                    return codePoint - 65 + 12;
                }
                if (97 <= codePoint && codePoint <= 122) {
                    return codePoint - 97 + 38;
                }
                return -1;
            }
        };
        public static final Base64Alphabet MOD_CRYPT_LE = new Base64Alphabet(true){

            @Override
            public int encode(int val) {
                if (val == 0) {
                    return 46;
                }
                if (val == 1) {
                    return 47;
                }
                if (val <= 11) {
                    return 48 + val - 2;
                }
                if (val <= 37) {
                    return 65 + val - 12;
                }
                assert (val < 64);
                return 97 + val - 38;
            }

            @Override
            public int decode(int codePoint) throws IllegalArgumentException {
                if (codePoint == 46) {
                    return 0;
                }
                if (codePoint == 47) {
                    return 1;
                }
                if (48 <= codePoint && codePoint <= 57) {
                    return codePoint - 48 + 2;
                }
                if (65 <= codePoint && codePoint <= 90) {
                    return codePoint - 65 + 12;
                }
                if (97 <= codePoint && codePoint <= 122) {
                    return codePoint - 97 + 38;
                }
                return -1;
            }
        };
        public static final Base64Alphabet BCRYPT = new Base64Alphabet(false){

            @Override
            public int encode(int val) {
                if (val == 0) {
                    return 46;
                }
                if (val == 1) {
                    return 47;
                }
                if (val <= 27) {
                    return 65 + val - 2;
                }
                if (val <= 53) {
                    return 97 + val - 28;
                }
                assert (val < 64);
                return 48 + val - 54;
            }

            @Override
            public int decode(int codePoint) {
                if (codePoint == 46) {
                    return 0;
                }
                if (codePoint == 47) {
                    return 1;
                }
                if (65 <= codePoint && codePoint <= 90) {
                    return codePoint - 65 + 2;
                }
                if (97 <= codePoint && codePoint <= 122) {
                    return codePoint - 97 + 28;
                }
                if (48 <= codePoint && codePoint <= 57) {
                    return codePoint - 48 + 54;
                }
                return -1;
            }
        };

        Base64Alphabet(boolean littleEndian) {
            super(littleEndian);
        }

        @Override
        public abstract int encode(int var1);

        @Override
        public abstract int decode(int var1);
    }
}

