/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.deployment.JmsDestination;
import org.wildfly.extension.messaging.activemq.deployment.MessagingAttachments;
import org.wildfly.extension.messaging.activemq.deployment.ParseResult;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;

public class MessagingXmlInstallDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List parseResults = deploymentUnit.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (ParseResult parseResult : parseResults) {
            String[] jndiBindings;
            ServiceName serverServiceName;
            for (JmsDestination topic : parseResult.getTopics()) {
                serverServiceName = MessagingServices.getActiveMQServiceName(topic.getServer());
                jndiBindings = null;
                if (topic.getDestination().hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = topic.getDestination().resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                JMSTopicService.installService(topic.getName(), serverServiceName, phaseContext.getServiceTarget(), jndiBindings);
                PathElement serverElement = PathElement.pathElement((String)"server", (String)topic.getServer());
                PathElement destination = PathElement.pathElement((String)"jms-topic", (String)topic.getName());
                deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, destination});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSTopicConfigurationRuntimeHandler.INSTANCE.registerResource(topic.getServer(), topic.getName(), topic.getDestination());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                serverServiceName = MessagingServices.getActiveMQServiceName(queue.getServer());
                jndiBindings = null;
                ModelNode destination = queue.getDestination();
                if (destination.hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = destination.resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                String selector = destination.hasDefined(CommonAttributes.SELECTOR.getName()) ? destination.get(CommonAttributes.SELECTOR.getName()).resolve().asString() : null;
                boolean durable = destination.hasDefined(CommonAttributes.DURABLE.getName()) ? destination.get(CommonAttributes.DURABLE.getName()).resolve().asBoolean() : false;
                JMSQueueService.installService(queue.getName(), phaseContext.getServiceTarget(), serverServiceName, selector, durable, jndiBindings);
                PathElement serverElement = PathElement.pathElement((String)"server", (String)queue.getServer());
                PathElement dest = PathElement.pathElement((String)"jms-queue", (String)queue.getName());
                deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSQueueConfigurationRuntimeHandler.INSTANCE.registerResource(queue.getServer(), queue.getName(), destination);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        List parseResults = context.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        for (ParseResult parseResult : parseResults) {
            for (JmsDestination topic : parseResult.getTopics()) {
                JMSTopicConfigurationRuntimeHandler.INSTANCE.unregisterResource(topic.getServer(), topic.getName());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                JMSQueueConfigurationRuntimeHandler.INSTANCE.unregisterResource(queue.getServer(), queue.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ManagementResourceRegistration createDeploymentSubModel(PathAddress address, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ManagementResourceRegistration registration = (ManagementResourceRegistration)unit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"messaging-activemq")});
            Resource subsystem = MessagingXmlInstallDeploymentUnitProcessor.getOrCreate(root, subsystemAddress);
            Set childTypes = subsystem.getChildTypes();
            ManagementResourceRegistration subModel = registration.getSubModel(subsystemAddress.append(address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            MessagingXmlInstallDeploymentUnitProcessor.getOrCreate(subsystem, address);
            return subModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource getOrCreate(Resource parent, PathAddress address) {
        Resource current = parent;
        for (PathElement element : address) {
            Resource resource = current;
            synchronized (resource) {
                if (current.hasChild(element)) {
                    current = current.requireChild(element);
                } else {
                    Resource resource2 = Resource.Factory.create();
                    current.registerChild(element, resource2);
                    current = resource2;
                }
            }
        }
        return current;
    }
}

