/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQAlreadyReplicatingException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupTopologyListener;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public class SharedNothingLiveActivation
extends LiveActivation {
    private ReplicatedPolicy replicatedPolicy;
    private ActiveMQServerImpl activeMQServer;
    private ReplicationManager replicationManager;
    private final Object replicationLock = new Object();

    public SharedNothingLiveActivation(ActiveMQServerImpl activeMQServer, ReplicatedPolicy replicatedPolicy) {
        this.activeMQServer = activeMQServer;
        this.replicatedPolicy = replicatedPolicy;
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        ReplicationManager localReplicationManager = this.replicationManager;
        if (remotingService != null && localReplicationManager != null) {
            remotingService.freeze(null, localReplicationManager.getBackupTransportConnection());
        } else if (remotingService != null) {
            remotingService.freeze(null, null);
        }
    }

    @Override
    public void run() {
        try {
            if (this.replicatedPolicy.isCheckForLiveServer() && this.isNodeIdUsed()) {
                this.replicatedPolicy.getReplicaPolicy().setReplicatedPolicy(this.replicatedPolicy);
                this.activeMQServer.setHAPolicy(this.replicatedPolicy.getReplicaPolicy());
                return;
            }
            this.activeMQServer.initialisePart1(false);
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation();
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsLive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    @Override
    public ChannelHandler getActivationChannelHandler(final Channel channel, final Acceptor acceptorUsed) {
        return new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 115) {
                    BackupRegistrationMessage msg = (BackupRegistrationMessage)packet;
                    ClusterConnection clusterConnection = acceptorUsed.getClusterConnection();
                    try {
                        SharedNothingLiveActivation.this.startReplication(channel.getConnection(), clusterConnection, (Pair<TransportConfiguration, TransportConfiguration>)SharedNothingLiveActivation.this.getPair(msg.getConnector(), true), msg.isFailBackRequest());
                    }
                    catch (ActiveMQAlreadyReplicatingException are) {
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.ALREADY_REPLICATING));
                    }
                    catch (ActiveMQException e) {
                        ActiveMQServerLogger.LOGGER.debug("Failed to process backup registration packet", e);
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.EXCEPTION));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplication(CoreRemotingConnection rc, final ClusterConnection clusterConnection, final Pair<TransportConfiguration, TransportConfiguration> pair, final boolean isFailBackRequest) throws ActiveMQException {
        if (this.replicationManager != null) {
            throw new ActiveMQAlreadyReplicatingException();
        }
        if (!this.activeMQServer.isStarted()) {
            throw new ActiveMQIllegalStateException();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.replicationManager != null) {
                throw new ActiveMQAlreadyReplicatingException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            rc.addCloseListener((CloseListener)listener);
            rc.addFailureListener((FailureListener)listener);
            this.replicationManager = new ReplicationManager(rc, this.activeMQServer.getExecutorFactory());
            this.replicationManager.start();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SharedNothingLiveActivation.this.activeMQServer.getStorageManager().startReplication(SharedNothingLiveActivation.this.replicationManager, SharedNothingLiveActivation.this.activeMQServer.getPagingManager(), SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), isFailBackRequest && SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack(), SharedNothingLiveActivation.this.replicatedPolicy.getInitialReplicationSyncTimeout());
                        clusterConnection.nodeAnnounced(System.currentTimeMillis(), SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), SharedNothingLiveActivation.this.replicatedPolicy.getGroupName(), SharedNothingLiveActivation.this.replicatedPolicy.getScaleDownGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)pair, true);
                        if (isFailBackRequest && SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack()) {
                            BackupTopologyListener listener1 = new BackupTopologyListener(SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString());
                            clusterConnection.addClusterTopologyListener(listener1);
                            if (listener1.waitForBackup()) {
                                if (!SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().isRestartBackup() && SharedNothingLiveActivation.this.activeMQServer.countNumberOfCopiedJournals() >= SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().getMaxSavedReplicatedJournalsSize() && SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().getMaxSavedReplicatedJournalsSize() >= 0) {
                                    SharedNothingLiveActivation.this.activeMQServer.stop(true);
                                    ActiveMQServerLogger.LOGGER.stopReplicatedBackupAfterFailback();
                                } else {
                                    SharedNothingLiveActivation.this.activeMQServer.stop(true);
                                    ActiveMQServerLogger.LOGGER.restartingReplicatedBackupAfterFailback();
                                    SharedNothingLiveActivation.this.activeMQServer.setHAPolicy(SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy());
                                    SharedNothingLiveActivation.this.activeMQServer.start();
                                }
                            } else {
                                ActiveMQServerLogger.LOGGER.failbackMissedBackupAnnouncement();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (SharedNothingLiveActivation.this.activeMQServer.getState() == ActiveMQServerImpl.SERVER_STATE.STARTED) {
                            ActiveMQServerLogger.LOGGER.errorStartingReplication(e);
                        }
                        try {
                            ActiveMQServerImpl.stopComponent(SharedNothingLiveActivation.this.replicationManager);
                        }
                        catch (Exception amqe) {
                            ActiveMQServerLogger.LOGGER.errorStoppingReplication(amqe);
                        }
                        finally {
                            Object object = SharedNothingLiveActivation.this.replicationLock;
                            synchronized (object) {
                                SharedNothingLiveActivation.this.replicationManager = null;
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
        if (isBackup) {
            return new Pair(null, (Object)conn);
        }
        return new Pair((Object)conn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNodeIdUsed() throws Exception {
        SimpleString nodeId0;
        if (this.activeMQServer.getConfiguration().getClusterConfigurations().isEmpty()) {
            return false;
        }
        try {
            nodeId0 = this.activeMQServer.getNodeManager().readNodeId();
        }
        catch (ActiveMQIllegalStateException e) {
            nodeId0 = null;
        }
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.activeMQServer.getConfiguration(), this.replicatedPolicy.getClusterName());
        ServerLocatorInternal locator = this.getLocator(config);
        ClientSessionFactoryInternal factory = null;
        NodeIdListener listener = new NodeIdListener(nodeId0);
        locator.addClusterTopologyListener((ClusterTopologyListener)listener);
        try {
            locator.setReconnectAttempts(0);
            try {
                locator.addClusterTopologyListener((ClusterTopologyListener)listener);
                factory = locator.connectNoWarnings();
            }
            catch (Exception notConnected) {
                boolean bl = false;
                if (factory != null) {
                    factory.close();
                }
                if (locator != null) {
                    locator.close();
                }
                return bl;
            }
            listener.latch.await(5L, TimeUnit.SECONDS);
            boolean bl = listener.isNodePresent;
            return bl;
        }
        finally {
            if (factory != null) {
                factory.close();
            }
            if (locator != null) {
                locator.close();
            }
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        this.replicationManager = null;
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            if (permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public void sendLiveIsStopping() {
        final ReplicationManager localReplicationManager = this.replicationManager;
        if (localReplicationManager != null) {
            localReplicationManager.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED);
            this.activeMQServer.getScheduledPool().schedule(new Runnable(){

                @Override
                public void run() {
                    localReplicationManager.clearReplicationTokens();
                }
            }, 30L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager getReplicationManager() {
        Object object = this.replicationLock;
        synchronized (object) {
            return this.replicationManager;
        }
    }

    private ServerLocatorInternal getLocator(ClusterConnectionConfiguration config) throws ActiveMQException {
        ServerLocatorInternal locator;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.activeMQServer.getConfiguration().getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                throw ActiveMQMessageBundle.BUNDLE.noDiscoveryGroupFound(dg);
            }
            locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        } else {
            TransportConfiguration[] tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        }
        return locator;
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.activeMQServer.getConfiguration().getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                ActiveMQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    static final class NodeIdListener
    implements ClusterTopologyListener {
        volatile boolean isNodePresent = false;
        private final SimpleString nodeId;
        private final CountDownLatch latch = new CountDownLatch(1);

        public NodeIdListener(SimpleString nodeId) {
            this.nodeId = nodeId;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            boolean isOurNodeId;
            boolean bl = isOurNodeId = this.nodeId != null && this.nodeId.toString().equals(topologyMember.getNodeId());
            if (isOurNodeId) {
                this.isNodePresent = true;
            }
            if (isOurNodeId || last) {
                this.latch.countDown();
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            this.connectionClosed();
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void connectionClosed() {
            SharedNothingLiveActivation.this.activeMQServer.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SharedNothingLiveActivation.this.replicationLock;
                    synchronized (object) {
                        if (SharedNothingLiveActivation.this.replicationManager != null) {
                            SharedNothingLiveActivation.this.activeMQServer.getStorageManager().stopReplication();
                            SharedNothingLiveActivation.this.replicationManager = null;
                        }
                    }
                }
            });
        }
    }
}

