/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.jboss.ejb.client.remoting.ClientMapping;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.logging.Logger;

final class ClusterNode {
    private static final Logger logger;
    private static final Collection<InetAddress> ALL_INET_ADDRESSES;
    private final String clusterName;
    private final String nodeName;
    private final ClientMapping[] clientMappings;
    private ResolvedDestination resolvedDestination;
    private final String cachedToString;

    ClusterNode(String clusterName, String nodeName, ClientMapping[] clientMappings) {
        this.clusterName = clusterName;
        this.nodeName = nodeName;
        this.clientMappings = clientMappings;
        this.resolveDestination();
        this.cachedToString = this.generateToString();
    }

    String getNodeName() {
        return this.nodeName;
    }

    String getDestinationAddress() {
        return this.resolvedDestination.destinationAddress;
    }

    int getDestinationPort() {
        return this.resolvedDestination.destinationPort;
    }

    boolean isDestinationResolved() {
        return this.resolvedDestination != null;
    }

    public String toString() {
        return this.cachedToString;
    }

    private String generateToString() {
        return "ClusterNode{clusterName='" + this.clusterName + '\'' + ", nodeName='" + this.nodeName + '\'' + ", clientMappings=" + (this.clientMappings == null ? null : Arrays.asList(this.clientMappings)) + ", resolvedDestination=" + this.resolvedDestination + '}';
    }

    private void resolveDestination() {
        for (ClientMapping clientMapping : this.clientMappings) {
            InetAddress sourceNetworkAddress = clientMapping.getSourceNetworkAddress();
            int netMask = clientMapping.getSourceNetworkMaskBits();
            for (InetAddress address : ALL_INET_ADDRESSES) {
                logger.debugf("Checking for a match of client address %s with client mapping %s", (Object)address, (Object)clientMapping);
                boolean match = NetworkUtil.belongsToNetwork(address, sourceNetworkAddress, netMask & 0xFF);
                if (!match) continue;
                logger.debugf("Client mapping %s matches client address %s", (Object)clientMapping, (Object)address);
                this.resolvedDestination = new ResolvedDestination(clientMapping.getDestinationAddress(), clientMapping.getDestinationPort());
                return;
            }
        }
    }

    private static Collection<InetAddress> getAllApplicableInetAddresses() throws SocketException {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                addresses.add(inetAddresses.nextElement());
            }
        }
        return addresses;
    }

    static {
        Collection<InetAddress> addresses;
        logger = Logger.getLogger(ClusterNode.class);
        try {
            addresses = ClusterNode.getAllApplicableInetAddresses();
        }
        catch (Throwable t) {
            logger.warn((Object)("Could not fetch the InetAddress(es) of this system due to " + t.getMessage()));
            logger.debug((Object)"Failed while fetching InetAddress(es) of this system ", t);
            addresses = Collections.emptySet();
        }
        ALL_INET_ADDRESSES = addresses;
    }

    private static final class ResolvedDestination {
        private final String destinationAddress;
        private final int destinationPort;

        ResolvedDestination(String destinationAddress, int destinationPort) {
            this.destinationAddress = NetworkUtil.formatPossibleIpv6Address(destinationAddress);
            this.destinationPort = destinationPort;
        }

        public String toString() {
            return "[Destination address=" + this.destinationAddress + ", destination port=" + this.destinationPort + "]";
        }
    }
}

