/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.api;

import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.strategy.OnePool;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolByCri;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolBySubject;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolBySubjectAndCri;
import org.jboss.jca.core.connectionmanager.pool.strategy.ReauthPool;

public class PoolFactory {
    public Pool create(PoolStrategy strategy, ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools, boolean sharable, String mcp) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy is null");
        }
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        switch (strategy) {
            case POOL_BY_CRI: {
                return new PoolByCri(mcf, pc, noTxSeparatePools, sharable, mcp);
            }
            case POOL_BY_SUBJECT: {
                return new PoolBySubject(mcf, pc, noTxSeparatePools, sharable, mcp);
            }
            case POOL_BY_SUBJECT_AND_CRI: {
                return new PoolBySubjectAndCri(mcf, pc, noTxSeparatePools, sharable, mcp);
            }
            case ONE_POOL: {
                return new OnePool(mcf, pc, noTxSeparatePools, sharable, mcp);
            }
            case REAUTH: {
                return new ReauthPool(mcf, pc, noTxSeparatePools, sharable, mcp);
            }
        }
        throw new IllegalArgumentException("Unknown strategy " + (Object)((Object)strategy));
    }
}

