/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.policy;

import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.Work;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.workmanager.WorkManagerUtil;
import org.jboss.jca.core.workmanager.policy.AbstractPolicy;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class WaterMark
extends AbstractPolicy {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WaterMark.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private int watermark = 0;

    @Override
    public synchronized boolean shouldDistribute(DistributedWorkManager dwm, DistributableWork work) {
        Boolean override;
        if (trace) {
            log.tracef("Work=%s", work);
        }
        if ((override = WorkManagerUtil.getShouldDistribute(work)) != null) {
            return override;
        }
        if (WorkManagerUtil.isLongRunning((Work)work) && dwm.getLongRunningThreadPool() != null) {
            return dwm.getLongRunningThreadPool().getNumberOfFreeThreads() <= (long)this.watermark;
        }
        return dwm.getShortRunningThreadPool().getNumberOfFreeThreads() <= (long)this.watermark;
    }

    public int getWatermark() {
        return this.watermark;
    }

    public void setWatermark(int value) {
        this.watermark = value;
    }
}

