/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentParsingProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentSchema;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentXMLReader;

public class SingletonServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        AbstractDeploymentChainStep step = new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget target) {
                for (SingletonDeploymentSchema schema : SingletonDeploymentSchema.values()) {
                    target.addDeploymentProcessor("singleton", Phase.STRUCTURE, 2588, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(schema.getRoot(), SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY, (JBossAllXMLParser)new SingletonDeploymentXMLReader(schema)));
                }
                target.addDeploymentProcessor("singleton", Phase.PARSE, 19200, (DeploymentUnitProcessor)new SingletonDeploymentParsingProcessor());
                target.addDeploymentProcessor("singleton", Phase.DEPENDENCIES, 8960, (DeploymentUnitProcessor)new SingletonDeploymentDependencyProcessor());
                target.addDeploymentProcessor("singleton", Phase.CONFIGURE_MODULE, 1024, (DeploymentUnitProcessor)new SingletonDeploymentProcessor());
            }
        };
        context.addStep((OperationStepHandler)step, OperationContext.Stage.RUNTIME);
        String defaultPolicy = SingletonResourceDefinition.Attribute.DEFAULT.getDefinition().resolveModelAttribute(context, model).asString();
        ServiceName serviceName = SingletonPolicyResourceDefinition.Capability.POLICY.getDefinition().getCapabilityServiceName();
        ServiceName targetServiceName = SingletonPolicyResourceDefinition.Capability.POLICY.getDefinition().getCapabilityServiceName(defaultPolicy);
        new AliasServiceBuilder(serviceName, targetServiceName, SingletonPolicy.class).build(context.getServiceTarget()).install();
    }

    public void removeServices(OperationContext context, ModelNode model) {
        context.removeService(SingletonPolicyResourceDefinition.Capability.POLICY.getDefinition().getCapabilityServiceName());
    }
}

