/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.workmanager.ClassBundle;
import org.jboss.jca.core.workmanager.ClassDefinition;
import org.jboss.jca.core.workmanager.ResourceAdapterClassLoader;
import org.jboss.jca.core.workmanager.SecurityActions;
import org.jboss.logging.Logger;

public class WorkClassLoader
extends ClassLoader {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkClassLoader.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private ResourceAdapterClassLoader resourceAdapterClassLoader;

    public WorkClassLoader(ClassBundle cb) {
        this(cb, null);
    }

    public WorkClassLoader(ClassBundle cb, ResourceAdapterClassLoader resourceAdapterClassLoader) {
        super(SecurityActions.getClassLoader(WorkClassLoader.class));
        ArrayList classes = new ArrayList(cb.getDefinitions().size());
        for (ClassDefinition classDefinition : cb.getDefinitions()) {
            if (trace) {
                log.tracef("%s: Defining class=%s", Integer.toHexString(System.identityHashCode(this)), classDefinition.getName());
            }
            Class<?> c = this.defineClass(classDefinition.getName(), classDefinition.getData(), 0, classDefinition.getData().length);
            classes.add(c);
        }
        for (Class clazz : classes) {
            if (trace) {
                log.tracef("%s: Resolving class=%s", Integer.toHexString(System.identityHashCode(this)), clazz.getName());
            }
            this.resolveClass(clazz);
        }
        this.resourceAdapterClassLoader = resourceAdapterClassLoader;
    }

    public void setResourceAdapterClassLoader(ResourceAdapterClassLoader v) {
        if (trace) {
            log.tracef("%s: setResourceAdapterClassLoader(%s)", Integer.toHexString(System.identityHashCode(this)), v);
        }
        this.resourceAdapterClassLoader = v;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result;
        if (trace) {
            log.tracef("%s: loadClass(%s)", Integer.toHexString(System.identityHashCode(this)), name);
        }
        if ((result = super.loadClass(name)) != null) {
            return result;
        }
        if (this.resourceAdapterClassLoader != null) {
            try {
                return this.resourceAdapterClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (trace) {
            log.tracef("%s: findClass(%s)", Integer.toHexString(System.identityHashCode(this)), name);
        }
        if (this.resourceAdapterClassLoader != null) {
            try {
                return this.resourceAdapterClassLoader.findClass(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.findClass(name);
    }

    Class<?> lookup(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        if (this.resourceAdapterClassLoader != null) {
            resource = this.resourceAdapterClassLoader.getResource(name);
        }
        if (resource != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.resourceAdapterClassLoader != null) {
            is = this.resourceAdapterClassLoader.getResourceAsStream(name);
        }
        if (is != null) {
            return is;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> v = new Vector<URL>();
        Enumeration<URL> e = null;
        if (this.resourceAdapterClassLoader != null) {
            e = this.resourceAdapterClassLoader.getResources(name);
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        e = super.getResources(name);
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v.elements();
    }

    @Override
    public void clearAssertionStatus() {
        super.clearAssertionStatus();
        if (this.resourceAdapterClassLoader != null) {
            this.resourceAdapterClassLoader.clearAssertionStatus();
        }
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        if (this.resourceAdapterClassLoader != null) {
            this.resourceAdapterClassLoader.setClassAssertionStatus(className, enabled);
        }
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        if (this.resourceAdapterClassLoader != null) {
            this.resourceAdapterClassLoader.setDefaultAssertionStatus(enabled);
        }
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        if (this.resourceAdapterClassLoader != null) {
            this.resourceAdapterClassLoader.setPackageAssertionStatus(packageName, enabled);
        }
        super.setPackageAssertionStatus(packageName, enabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[parent=").append(this.getParent());
        sb.append(" resourceAdapterClassLoader=").append(this.resourceAdapterClassLoader);
        sb.append("]");
        return sb.toString();
    }
}

