/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ManagementUtil;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSServerControlHandler
extends AbstractRuntimeOnlyHandler {
    private static final AttributeDefinition ADDRESS_NAME = OperationDefinitionHelper.createNonEmptyStringAttribute("address-name");
    private static final AttributeDefinition SESSION_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("session-id");
    private static final AttributeDefinition CONNECTION_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("connection-id");
    public static final String LIST_CONNECTIONS_AS_JSON = "list-connections-as-json";
    public static final String LIST_CONSUMERS_AS_JSON = "list-consumers-as-json";
    public static final String LIST_ALL_CONSUMERS_AS_JSON = "list-all-consumers-as-json";
    public static final String LIST_TARGET_DESTINATIONS = "list-target-destinations";
    public static final String GET_LAST_SENT_MESSAGE_ID = "get-last-sent-message-id";
    public static final String GET_SESSION_CREATION_TIME = "get-session-creation-time";
    public static final String LIST_SESSIONS_AS_JSON = "list-sessions-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON = "list-prepared-transaction-jms-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML = "list-prepared-transaction-jms-details-as-html";
    public static final JMSServerControlHandler INSTANCE = new JMSServerControlHandler();

    private JMSServerControlHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block14: {
            if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            String operationName = operation.require("operation").asString();
            JMSServerControl serverControl = this.getServerControl(context, operation);
            if (serverControl == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
            }
            try {
                if (LIST_CONNECTIONS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listConnectionsAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_CONSUMERS_AS_JSON.equals(operationName)) {
                    String connectionID = CONNECTION_ID.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.listConsumersAsJSON(connectionID);
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_ALL_CONSUMERS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listAllConsumersAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_TARGET_DESTINATIONS.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    String[] list = serverControl.listTargetDestinations(sessionID);
                    ManagementUtil.reportListOfStrings(context, list);
                    break block14;
                }
                if (GET_LAST_SENT_MESSAGE_ID.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    String addressName = ADDRESS_NAME.resolveModelAttribute(context, operation).asString();
                    String msgId = serverControl.getLastSentMessageID(sessionID, addressName);
                    context.getResult().set(msgId);
                    break block14;
                }
                if (GET_SESSION_CREATION_TIME.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    String time = serverControl.getSessionCreationTime(sessionID);
                    context.getResult().set(time);
                    break block14;
                }
                if (LIST_SESSIONS_AS_JSON.equals(operationName)) {
                    String connectionID = CONNECTION_ID.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.listSessionsAsJSON(connectionID);
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block14;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONNECTIONS_AS_JSON, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONSUMERS_AS_JSON, resolver).setParameters(new AttributeDefinition[]{CONNECTION_ID}).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_ALL_CONSUMERS_AS_JSON, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_TARGET_DESTINATIONS, resolver).setParameters(new AttributeDefinition[]{SESSION_ID}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_LAST_SENT_MESSAGE_ID, resolver).setParameters(new AttributeDefinition[]{SESSION_ID, ADDRESS_NAME}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_SESSION_CREATION_TIME, resolver).setParameters(new AttributeDefinition[]{SESSION_ID}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_SESSIONS_AS_JSON, resolver).setParameters(new AttributeDefinition[]{CONNECTION_ID}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
    }

    private JMSServerControl getServerControl(OperationContext context, ModelNode operation) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        return (JMSServerControl)JMSServerControl.class.cast(server.getManagementService().getResource("jms.server"));
    }
}

