/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseExporter;
import org.hibernate.tool.hbm2ddl.Exporter;
import org.hibernate.tool.hbm2ddl.FileExporter;
import org.hibernate.tool.hbm2ddl.ImportScriptException;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractorInitiator;
import org.hibernate.tool.hbm2ddl.ScriptExporter;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.Target;
import org.hibernate.tool.schema.spi.SchemaManagementTool;

public class SchemaExport {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SchemaExport.class);
    private static final String DEFAULT_IMPORT_FILE = "/import.sql";
    private final ConnectionHelper connectionHelper;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final ClassLoaderService classLoaderService;
    private final String[] dropSQL;
    private final String[] createSQL;
    private final String importFiles;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private Formatter formatter;
    private ImportSqlCommandExtractor importSqlCommandExtractor = ImportSqlCommandExtractorInitiator.DEFAULT_EXTRACTOR;
    private String outputFile;
    private String delimiter;
    private boolean haltOnError;

    public SchemaExport(MetadataImplementor metadata) {
        this((ServiceRegistry)metadata.getMetadataBuildingOptions().getServiceRegistry(), metadata);
    }

    public SchemaExport(MetadataImplementor metadata, boolean createNamespaces) {
        this(metadata.getMetadataBuildingOptions().getServiceRegistry(), metadata, createNamespaces);
    }

    public SchemaExport(ServiceRegistry serviceRegistry, MetadataImplementor metadata) {
        this(new SuppliedConnectionProviderConnectionHelper(serviceRegistry.getService(ConnectionProvider.class)), serviceRegistry, metadata, false);
    }

    public SchemaExport(ServiceRegistry serviceRegistry, MetadataImplementor metadata, boolean createNamespaces) {
        this(new SuppliedConnectionProviderConnectionHelper(serviceRegistry.getService(ConnectionProvider.class)), serviceRegistry, metadata, createNamespaces);
    }

    private SchemaExport(ConnectionHelper connectionHelper, ServiceRegistry serviceRegistry, MetadataImplementor metadata, boolean createNamespaces) {
        this.connectionHelper = connectionHelper;
        this.sqlStatementLogger = serviceRegistry.getService(JdbcServices.class).getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.sqlExceptionHelper = serviceRegistry.getService(JdbcEnvironment.class).getSqlExceptionHelper();
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", serviceRegistry.getService(ConfigurationService.class).getSettings(), DEFAULT_IMPORT_FILE);
        SchemaManagementTool schemaManagementTool = serviceRegistry.getService(SchemaManagementTool.class);
        final ArrayList commands = new ArrayList();
        org.hibernate.tool.schema.spi.Target target = new org.hibernate.tool.schema.spi.Target(){

            @Override
            public boolean acceptsImportScriptActions() {
                return false;
            }

            @Override
            public void prepare() {
                commands.clear();
            }

            @Override
            public void accept(String command) {
                commands.add(command);
            }

            @Override
            public void release() {
            }
        };
        Map settings = serviceRegistry.getService(ConfigurationService.class).getSettings();
        schemaManagementTool.getSchemaDropper(settings).doDrop((Metadata)metadata, createNamespaces, target);
        this.dropSQL = commands.toArray(new String[commands.size()]);
        schemaManagementTool.getSchemaCreator(settings).doCreation((Metadata)metadata, createNamespaces, target);
        this.createSQL = commands.toArray(new String[commands.size()]);
    }

    public SchemaExport(ConnectionHelper connectionHelper, MetadataImplementor metadata) {
        this(connectionHelper, metadata.getMetadataBuildingOptions().getServiceRegistry(), metadata, false);
    }

    public SchemaExport(MetadataImplementor metadata, Connection connection) throws HibernateException {
        this(new SuppliedConnectionHelper(connection), metadata);
    }

    @Deprecated
    public SchemaExport(ServiceRegistry serviceRegistry, Configuration configuration) {
        throw new UnsupportedOperationException("Attempt to use unsupported SchemaExport constructor accepting org.hibernate.cfg.Configuration; one of the forms accepting org.hibernate.boot.spi.MetadataImplementor should be used instead");
    }

    @Deprecated
    public SchemaExport(Configuration configuration) {
        throw new UnsupportedOperationException("Attempt to use unsupported SchemaExport constructor accepting org.hibernate.cfg.Configuration; one of the forms accepting org.hibernate.boot.spi.MetadataImplementor should be used instead");
    }

    @Deprecated
    public SchemaExport(Configuration configuration, Connection connection) throws HibernateException {
        throw new UnsupportedOperationException("Attempt to use unsupported SchemaExport constructor accepting org.hibernate.cfg.Configuration; one of the forms accepting org.hibernate.boot.spi.MetadataImplementor should be used instead");
    }

    public SchemaExport(ConnectionHelper connectionHelper, String[] dropSql, String[] createSql) {
        this.connectionHelper = connectionHelper;
        this.dropSQL = dropSql;
        this.createSQL = createSql;
        this.importFiles = "";
        this.sqlStatementLogger = new SqlStatementLogger(false, true);
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.classLoaderService = new ClassLoaderServiceImpl();
        this.formatter = FormatStyle.DDL.getFormatter();
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public SchemaExport setFormat(boolean format) {
        this.formatter = (format ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        return this;
    }

    public SchemaExport setImportSqlCommandExtractor(ImportSqlCommandExtractor importSqlCommandExtractor) {
        this.importSqlCommandExtractor = importSqlCommandExtractor;
        return this;
    }

    public SchemaExport setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.create(Target.interpret(script, export));
    }

    public void create(Target output) {
        this.execute(output, Type.BOTH);
    }

    public void drop(boolean script, boolean export) {
        this.drop(Target.interpret(script, export));
    }

    public void drop(Target output) {
        this.execute(output, Type.DROP);
    }

    public void execute(boolean script, boolean export, boolean justDrop, boolean justCreate) {
        this.execute(Target.interpret(script, export), this.interpretType(justDrop, justCreate));
    }

    private Type interpretType(boolean justDrop, boolean justCreate) {
        if (justDrop) {
            return Type.DROP;
        }
        if (justCreate) {
            return Type.CREATE;
        }
        return Type.BOTH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Target output, Type type) {
        if (this.outputFile == null && output == Target.NONE || type == Type.NONE) {
            return;
        }
        this.exceptions.clear();
        LOG.runningHbm2ddlSchemaExport();
        ArrayList<NamedReader> importFileReaders = new ArrayList<NamedReader>();
        for (String currentFile : this.importFiles.split(",")) {
            String resourceName = currentFile.trim();
            InputStream stream = this.classLoaderService.locateResourceStream(resourceName);
            if (stream == null) {
                LOG.debugf("Import file not found: %s", currentFile);
                continue;
            }
            importFileReaders.add(new NamedReader(resourceName, stream));
        }
        ArrayList<Exporter> exporters = new ArrayList<Exporter>();
        try {
            if (output.doScript()) {
                exporters.add(new ScriptExporter());
            }
            if (this.outputFile != null) {
                exporters.add(new FileExporter(this.outputFile));
            }
            if (output.doExport()) {
                exporters.add(new DatabaseExporter(this.connectionHelper, this.sqlExceptionHelper));
            }
            if (type.doDrop()) {
                this.perform(this.dropSQL, exporters);
            }
            if (type.doCreate()) {
                this.perform(this.createSQL, exporters);
                if (!importFileReaders.isEmpty()) {
                    for (NamedReader namedReader : importFileReaders) {
                        this.importScript(namedReader, exporters);
                    }
                }
            }
        }
        catch (Exception e) {
            this.exceptions.add(e);
            LOG.schemaExportUnsuccessful(e);
        }
        finally {
            for (Exporter exporter : exporters) {
                try {
                    exporter.release();
                }
                catch (Exception exception) {}
            }
            for (NamedReader namedReader : importFileReaders) {
                try {
                    namedReader.getReader().close();
                }
                catch (Exception exception) {}
            }
            LOG.schemaExportComplete();
        }
    }

    private void perform(String[] sqlCommands, List<Exporter> exporters) {
        for (String sqlCommand : sqlCommands) {
            String formatted = this.formatter.format(sqlCommand);
            if (this.delimiter != null) {
                formatted = formatted + this.delimiter;
            }
            this.sqlStatementLogger.logStatement(sqlCommand, this.formatter);
            for (Exporter exporter : exporters) {
                try {
                    exporter.export(formatted);
                }
                catch (Exception e) {
                    if (this.haltOnError) {
                        throw new HibernateException("Error during DDL export", e);
                    }
                    this.exceptions.add(e);
                    LOG.unsuccessfulCreate(sqlCommand);
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    private void importScript(NamedReader namedReader, List<Exporter> exporters) throws Exception {
        BufferedReader reader = new BufferedReader(namedReader.getReader());
        String[] statements = this.importSqlCommandExtractor.extractCommands(reader);
        if (statements != null) {
            for (String statement : statements) {
                if (statement == null) continue;
                String trimmedSql = statement.trim();
                if (trimmedSql.endsWith(";")) {
                    trimmedSql = trimmedSql.substring(0, statement.length() - 1);
                }
                if (StringHelper.isEmpty(trimmedSql)) continue;
                try {
                    for (Exporter exporter : exporters) {
                        if (!exporter.acceptsImportScripts()) continue;
                        exporter.export(trimmedSql);
                    }
                }
                catch (Exception e) {
                    if (this.haltOnError) {
                        throw new ImportScriptException("Error during statement execution (file: '" + namedReader.getName() + "'): " + trimmedSql, e);
                    }
                    this.exceptions.add(e);
                    LOG.unsuccessful(trimmedSql);
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLineArgs commandLineArgs = CommandLineArgs.parseCommandLineArgs(args);
            StandardServiceRegistry serviceRegistry = SchemaExport.buildStandardServiceRegistry(commandLineArgs);
            try {
                MetadataImplementor metadata = SchemaExport.buildMetadata(commandLineArgs, serviceRegistry);
                SchemaExport schemaExport = new SchemaExport(serviceRegistry, metadata, commandLineArgs.exportSchemas).setHaltOnError(commandLineArgs.halt).setOutputFile(commandLineArgs.outputFile).setDelimiter(commandLineArgs.delimiter).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class)).setFormat(commandLineArgs.format);
                schemaExport.execute(commandLineArgs.script, commandLineArgs.export, commandLineArgs.drop, commandLineArgs.create);
            }
            finally {
                StandardServiceRegistryBuilder.destroy(serviceRegistry);
            }
        }
        catch (Exception e) {
            LOG.unableToCreateSchema(e);
            e.printStackTrace();
        }
    }

    private static StandardServiceRegistry buildStandardServiceRegistry(CommandLineArgs commandLineArgs) throws Exception {
        BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        if (commandLineArgs.cfgXmlFile != null) {
            ssrBuilder.configure(commandLineArgs.cfgXmlFile);
        }
        Properties properties = new Properties();
        if (commandLineArgs.propertiesFile != null) {
            properties.load(new FileInputStream(commandLineArgs.propertiesFile));
        }
        ssrBuilder.applySettings(properties);
        if (commandLineArgs.importFile != null) {
            ssrBuilder.applySetting("hibernate.hbm2ddl.import_files", commandLineArgs.importFile);
        }
        return ssrBuilder.build();
    }

    private static MetadataImplementor buildMetadata(CommandLineArgs parsedArgs, StandardServiceRegistry serviceRegistry) throws Exception {
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        for (String filename : parsedArgs.hbmXmlFiles) {
            metadataSources.addFile(filename);
        }
        for (String filename : parsedArgs.jarFiles) {
            metadataSources.addJar(new File(filename));
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        if (parsedArgs.implicitNamingStrategyImplName != null) {
            metadataBuilder.applyImplicitNamingStrategy(strategySelector.resolveStrategy(ImplicitNamingStrategy.class, parsedArgs.implicitNamingStrategyImplName));
        }
        if (parsedArgs.physicalNamingStrategyImplName != null) {
            metadataBuilder.applyPhysicalNamingStrategy(strategySelector.resolveStrategy(PhysicalNamingStrategy.class, parsedArgs.physicalNamingStrategyImplName));
        }
        return (MetadataImplementor)metadataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataImplementor buildMetadataFromMainArgs(String[] args) throws Exception {
        CommandLineArgs commandLineArgs = CommandLineArgs.parseCommandLineArgs(args);
        StandardServiceRegistry serviceRegistry = SchemaExport.buildStandardServiceRegistry(commandLineArgs);
        try {
            MetadataImplementor metadataImplementor = SchemaExport.buildMetadata(commandLineArgs, serviceRegistry);
            return metadataImplementor;
        }
        finally {
            StandardServiceRegistryBuilder.destroy(serviceRegistry);
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    private static class CommandLineArgs {
        boolean script = true;
        boolean drop = false;
        boolean create = false;
        boolean halt = false;
        boolean export = true;
        boolean format = false;
        boolean exportSchemas = false;
        String delimiter = null;
        String outputFile = null;
        String importFile = "/import.sql";
        String propertiesFile = null;
        String cfgXmlFile = null;
        String implicitNamingStrategyImplName = null;
        String physicalNamingStrategyImplName = null;
        List<String> hbmXmlFiles = new ArrayList<String>();
        List<String> jarFiles = new ArrayList<String>();

        private CommandLineArgs() {
        }

        public static CommandLineArgs parseCommandLineArgs(String[] args) {
            CommandLineArgs parsedArgs = new CommandLineArgs();
            for (String arg : args) {
                if (arg.startsWith("--")) {
                    if (arg.equals("--quiet")) {
                        parsedArgs.script = false;
                        continue;
                    }
                    if (arg.equals("--drop")) {
                        parsedArgs.drop = true;
                        continue;
                    }
                    if (arg.equals("--create")) {
                        parsedArgs.create = true;
                        continue;
                    }
                    if (arg.equals("--schemas")) {
                        parsedArgs.exportSchemas = true;
                        continue;
                    }
                    if (arg.equals("--haltonerror")) {
                        parsedArgs.halt = true;
                        continue;
                    }
                    if (arg.equals("--text")) {
                        parsedArgs.export = false;
                        continue;
                    }
                    if (arg.startsWith("--output=")) {
                        parsedArgs.outputFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--import=")) {
                        parsedArgs.importFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--properties=")) {
                        parsedArgs.propertiesFile = arg.substring(13);
                        continue;
                    }
                    if (arg.equals("--format")) {
                        parsedArgs.format = true;
                        continue;
                    }
                    if (arg.startsWith("--delimiter=")) {
                        parsedArgs.delimiter = arg.substring(12);
                        continue;
                    }
                    if (arg.startsWith("--config=")) {
                        parsedArgs.cfgXmlFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--naming=")) {
                        DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedNamingStrategyArgument();
                        continue;
                    }
                    if (arg.startsWith("--implicit-naming=")) {
                        parsedArgs.implicitNamingStrategyImplName = arg.substring(18);
                        continue;
                    }
                    if (!arg.startsWith("--physical-naming=")) continue;
                    parsedArgs.physicalNamingStrategyImplName = arg.substring(18);
                    continue;
                }
                if (arg.endsWith(".jar")) {
                    parsedArgs.jarFiles.add(arg);
                    continue;
                }
                parsedArgs.hbmXmlFiles.add(arg);
            }
            return parsedArgs;
        }
    }

    private static class NamedReader {
        private final Reader reader;
        private final String name;

        public NamedReader(String name, InputStream stream) {
            this.name = name;
            this.reader = new InputStreamReader(stream);
        }

        public Reader getReader() {
            return this.reader;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        CREATE,
        DROP,
        NONE,
        BOTH;


        public boolean doCreate() {
            return this == BOTH || this == CREATE;
        }

        public boolean doDrop() {
            return this == BOTH || this == DROP;
        }
    }
}

