/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueBoxGen
implements com.sun.tools.corba.se.idl.ValueBoxGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected ValueBoxEntry v = null;
    protected PrintWriter stream = null;

    @Override
    public void generate(Hashtable symbolTable, ValueBoxEntry v, PrintWriter str) {
        this.symbolTable = symbolTable;
        this.v = v;
        TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
        SymtabEntry mType = member.type();
        if (mType instanceof PrimitiveEntry) {
            this.openStream();
            if (this.stream == null) {
                return;
            }
            this.writeHeading();
            this.writeBody();
            this.writeClosing();
            this.closeStream();
        } else {
            Enumeration e = v.contained().elements();
            while (e.hasMoreElements()) {
                SymtabEntry contained = (SymtabEntry)e.nextElement();
                if (contained.type() == null) continue;
                contained.type().generate(symbolTable, this.stream);
            }
        }
        this.generateHelper();
        this.generateHolder();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        this.stream.println("public class " + this.v.name() + " implements org.omg.CORBA.portable.ValueBase");
        this.stream.println("{");
    }

    protected void writeBody() {
        InterfaceState member = (InterfaceState)this.v.state().elementAt(0);
        TypedefEntry entry = member.entry;
        Util.fillInfo(entry);
        if (entry.comment() != null) {
            entry.comment().generate(" ", this.stream);
        }
        this.stream.println("  public " + Util.javaName(entry) + " value;");
        this.stream.println("  public " + this.v.name() + " (" + Util.javaName(entry) + " initial)");
        this.stream.println("  {");
        this.stream.println("    value = initial;");
        this.stream.println("  }");
        this.stream.println();
        this.writeTruncatable();
    }

    protected void writeTruncatable() {
        this.stream.println("  public String[] _truncatable_ids() {");
        this.stream.println("      return " + Util.helperName(this.v, true) + ".get_instance().get_truncatable_base_ids();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.v.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.streamableRead("this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    @Override
    public int helperType(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        ValueEntry vt = (ValueEntry)entry;
        TypedefEntry member = ((InterfaceState)vt.state().elementAt((int)0)).entry;
        SymtabEntry mType = Util.typeOf(member);
        index = ((JavaGenerator)((Object)mType.generator())).type(index, indent, tcoffsets, name, mType, stream);
        stream.println(indent + name + " = org.omg.CORBA.ORB.init ().create_value_box_tc (" + "_id, " + '\"' + entry.name() + "\", " + name + ");");
        return index;
    }

    @Override
    public int type(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        stream.println(indent + name + " = " + Util.helperName(entry, true) + ".type ();");
        return index;
    }

    @Override
    public int read(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        return index;
    }

    @Override
    public void helperRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        stream.println("    return (" + entryName + ") ((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (get_instance());");
        stream.println("  }");
        stream.println();
        stream.println("  public java.io.Serializable read_value (org.omg.CORBA.portable.InputStream istream)");
        stream.println("  {");
        String indent = "    ";
        Vector vMembers = ((ValueBoxEntry)entry).state();
        TypedefEntry member = ((InterfaceState)vMembers.elementAt((int)0)).entry;
        SymtabEntry mType = member.type();
        if (mType instanceof PrimitiveEntry || mType instanceof SequenceEntry || mType instanceof TypedefEntry || mType instanceof StringEntry || !member.arrayInfo().isEmpty()) {
            stream.println(indent + Util.javaName(mType) + " tmp;");
            ((JavaGenerator)((Object)member.generator())).read(0, indent, "tmp", member, stream);
        } else if (mType instanceof ValueEntry || mType instanceof ValueBoxEntry) {
            stream.println(indent + Util.javaQualifiedName(mType) + " tmp = (" + Util.javaQualifiedName(mType) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(mType, true) + ".get_instance ());");
        } else {
            stream.println(indent + Util.javaName(mType) + " tmp = " + Util.helperName(mType, true) + ".read (istream);");
        }
        if (mType instanceof PrimitiveEntry) {
            stream.println(indent + "return new " + entryName + " (tmp);");
        } else {
            stream.println(indent + "return tmp;");
        }
    }

    @Override
    public void helperWrite(SymtabEntry entry, PrintWriter stream) {
        stream.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, get_instance());");
        stream.println("  }");
        stream.println();
        stream.println("  public void write_value (org.omg.CORBA.portable.OutputStream ostream, java.io.Serializable obj)");
        stream.println("  {");
        String entryName = Util.javaName(entry);
        stream.println("    " + entryName + " value  = (" + entryName + ") obj;");
        this.write(0, "    ", "value", entry, stream);
    }

    @Override
    public int write(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        Vector vMembers = ((ValueEntry)entry).state();
        TypedefEntry member = ((InterfaceState)vMembers.elementAt((int)0)).entry;
        SymtabEntry mType = member.type();
        if (mType instanceof PrimitiveEntry || !member.arrayInfo().isEmpty()) {
            index = ((JavaGenerator)((Object)member.generator())).write(index, indent, name + ".value", member, stream);
        } else if (mType instanceof SequenceEntry || mType instanceof StringEntry || mType instanceof TypedefEntry || !member.arrayInfo().isEmpty()) {
            index = ((JavaGenerator)((Object)member.generator())).write(index, indent, name, member, stream);
        } else if (mType instanceof ValueEntry || mType instanceof ValueBoxEntry) {
            stream.println(indent + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value ((java.io.Serializable) value, " + Util.helperName(mType, true) + ".get_instance ());");
        } else {
            stream.println(indent + Util.helperName(mType, true) + ".write (ostream, " + name + ");");
        }
        return index;
    }

    protected void writeAbstract() {
    }

    protected void streamableRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        Vector vMembers = ((ValueBoxEntry)entry).state();
        TypedefEntry member = ((InterfaceState)vMembers.elementAt((int)0)).entry;
        SymtabEntry mType = member.type();
        if (mType instanceof PrimitiveEntry || mType instanceof SequenceEntry || mType instanceof TypedefEntry || mType instanceof StringEntry || !member.arrayInfo().isEmpty()) {
            TypedefEntry mEntry = ((InterfaceState)vMembers.elementAt((int)0)).entry;
            ((JavaGenerator)((Object)member.generator())).read(0, "    ", entryName + ".value", member, stream);
        } else if (mType instanceof ValueEntry || mType instanceof ValueBoxEntry) {
            stream.println("    " + entryName + ".value = (" + Util.javaQualifiedName(mType) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(mType, true) + ".get_instance ());");
        } else {
            stream.println("    " + entryName + ".value = " + Util.helperName(mType, true) + ".read (istream);");
        }
    }
}

