/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class TermQueryContext {
    private static final Log log = LoggerFactory.make();
    private final Approximation approximation;
    private int maxEditDistance = 2;
    private int prefixLength = 0;
    private Float threshold;

    public TermQueryContext(Approximation approximation) {
        this.approximation = approximation;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public Approximation getApproximation() {
        return this.approximation;
    }

    public int getMaxEditDistance() {
        return this.maxEditDistance;
    }

    public void setMaxEditDistance(int maxEditDistance) {
        if (maxEditDistance < 1 || maxEditDistance > 2) {
            throw log.incorrectEditDistance();
        }
        this.maxEditDistance = maxEditDistance;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = Float.valueOf(threshold);
    }

    public static enum Approximation {
        EXACT,
        WILDCARD,
        FUZZY;

    }
}

