/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.common.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.Capabilities;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyDefinition;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnableDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourcesExtension;
import org.jboss.as.connector.subsystems.datasources.XMLDataSourceRuntimeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class DataSourceDefinition
extends SimpleResourceDefinition {
    protected static final PathElement PATH_DATASOURCE = PathElement.pathElement((String)"data-source");
    private static final String LEGACY_MCP = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool";
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private DataSourceDefinition(boolean registerRuntimeOnly, boolean deployed) {
        super(PATH_DATASOURCE, (ResourceDescriptionResolver)DataSourcesExtension.getResourceDescriptionResolver("data-source"), (OperationStepHandler)(deployed ? null : DataSourceAdd.INSTANCE), (OperationStepHandler)(deployed ? null : ReloadRequiredRemoveStepHandler.INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("datasources", "data-source");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public static DataSourceDefinition createInstance(boolean registerRuntimeOnly, boolean deployed) {
        return new DataSourceDefinition(registerRuntimeOnly, deployed);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (!this.deployed) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_ENABLE, (OperationStepHandler)DataSourceEnableDisable.ENABLE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_DISABLE, (OperationStepHandler)DataSourceEnableDisable.DISABLE);
        }
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_IDLE_CONNECTION, (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_ALL_CONNECTION, (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DUMP_QUEUED_THREADS, (OperationStepHandler)PoolOperations.DumpQueuedThreadInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_INVALID_CONNECTION, (OperationStepHandler)PoolOperations.FlushInvalidConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_GRACEFULLY_CONNECTION, (OperationStepHandler)PoolOperations.FlushGracefullyConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.TEST_CONNECTION, (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        if (!this.deployed) {
            resourceRegistration.registerCapability(Capabilities.DATA_SOURCE_CAPABILITY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            SimpleAttributeDefinition runtimeAttribute;
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_ATTRIBUTE) {
                runtimeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE);
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_PROPERTIES_ATTRIBUTES) {
                runtimeAttribute = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder((PropertiesAttributeDefinition)simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE);
            }
        } else {
            void var5_13;
            ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])Constants.DATASOURCE_ATTRIBUTE);
            SimpleAttributeDefinition[] simpleAttributeDefinitionArray = Constants.DATASOURCE_ATTRIBUTE;
            int n = simpleAttributeDefinitionArray.length;
            boolean bl = false;
            while (var5_13 < n) {
                SimpleAttributeDefinition attribute = simpleAttributeDefinitionArray[var5_13];
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                } else {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
                }
                ++var5_13;
            }
            ReloadRequiredWriteAttributeHandler reloadRequiredPropertiesWriteHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])Constants.DATASOURCE_PROPERTIES_ATTRIBUTES);
            for (PropertiesAttributeDefinition attribute : Constants.DATASOURCE_PROPERTIES_ATTRIBUTES) {
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                    continue;
                }
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)reloadRequiredPropertiesWriteHandler);
            }
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            resourceRegistration.registerSubModel((ResourceDefinition)ConnectionPropertyDefinition.DEPLOYED_INSTANCE);
        } else {
            resourceRegistration.registerSubModel((ResourceDefinition)ConnectionPropertyDefinition.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    static void registerTransformers120(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{Constants.CONNECTABLE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(LEGACY_MCP)}), new AttributeDefinition[]{Constants.MCP})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.MCP})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

            protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.equals(new ModelNode(false));
            }
        }, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
    }

    static void registerTransformers130(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

            protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.equals(new ModelNode(false));
            }
        }, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).end();
    }

    static void registerTransformers200(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{Constants.CONNECTABLE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(LEGACY_MCP)}), new AttributeDefinition[]{Constants.MCP})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.MCP})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

            protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.equals(new ModelNode(false));
            }
        }, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
    }

    static void registerTransformers300(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(LEGACY_MCP)}), new AttributeDefinition[]{Constants.MCP})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ALLOW_MULTIPLE_USERS})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.MCP})).end();
    }
}

