/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims.mapper;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.ClaimsMapper;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.claims.mapper.ClaimUtils;

public class JexlClaimsMapper
implements ClaimsMapper {
    private static final Logger LOG = LogUtils.getL7dLogger(JexlClaimsMapper.class);
    private JexlEngine jexlEngine = new JexlEngine();
    private Script script;

    public JexlClaimsMapper() {
        this.jexlEngine.setSilent(false);
        HashMap<String, Object> functions = new HashMap<String, Object>();
        functions.put("claims", new ClaimUtils());
        functions.put("LOG", LOG);
        this.jexlEngine.setFunctions(functions);
    }

    public JexlClaimsMapper(String script) throws IOException {
        this();
        if (script != null) {
            this.setScript(script);
        }
    }

    @Override
    public ProcessedClaimCollection mapClaims(String sourceRealm, ProcessedClaimCollection sourceClaims, String targetRealm, ClaimsParameters parameters) {
        MapContext context = new MapContext();
        context.set("sourceClaims", (Object)sourceClaims);
        context.set("targetClaims", (Object)new ProcessedClaimCollection());
        context.set("sourceRealm", (Object)sourceRealm);
        context.set("targetRealm", (Object)targetRealm);
        context.set("claimsParameters", (Object)parameters);
        Script s = this.getScript();
        if (s == null) {
            LOG.warning("No claim mapping script defined");
            return new ProcessedClaimCollection();
        }
        return (ProcessedClaimCollection)s.execute((JexlContext)context);
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setScript(String scriptLocation) throws IOException {
        File scriptFile;
        URL resource = ClassLoaderUtils.getResource((String)scriptLocation, this.getClass());
        if (resource != null) {
            scriptLocation = resource.getPath();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Script found within Classpath: " + scriptLocation);
            }
        }
        if (!(scriptFile = new File(scriptLocation)).exists()) {
            throw new IllegalArgumentException("Script resource not found!");
        }
        this.script = this.jexlEngine.createScript(scriptFile);
    }

    public JexlEngine getJexlEngine() {
        return this.jexlEngine;
    }

    public void setJexlEngine(JexlEngine jexl) {
        this.jexlEngine = jexl;
    }
}

