/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

class MailServerAdd
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;

    MailServerAdd(AttributeDefinition[] attributes) {
        super("mail-session");
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : this.attributes) {
            def.validateAndSet(operation, model);
        }
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        MailSessionAdd.installRuntimeServices(context, parentAddress, parentModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return MailSessionAdd.MAIL_SESSION_SERVICE_NAME.append(new String[]{parentAddress.getLastElement().getValue()});
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        super.removeServices(context, parentService, parentModel);
        String jndiName = MailSessionAdd.getJndiName(parentModel, context);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
    }
}

