/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.listeners;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;

public class IDPHttpSessionListener
implements HttpSessionListener {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession httpSession = se.getSession();
        if (httpSession == null) {
            throw logger.nullArgumentError("session");
        }
        AssertionType assertion = (AssertionType)httpSession.getAttribute("ASSERTION");
        if (assertion != null) {
            logger.trace("User has closed the browser. So we proceed to cancel the STS issued token.");
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
            samlProtocolContext.setIssuedAssertion(assertion);
            try {
                sts.cancelToken(samlProtocolContext);
            }
            catch (ProcessingException e) {
                logger.error((Throwable)e);
            }
            httpSession.removeAttribute("ASSERTION");
        }
    }
}

