/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.constraint.ServerGroupEffectConstraint;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;

class ServerGroupScopedRoleWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final Map<String, ServerGroupEffectConstraint> constraintMap;

    public ServerGroupScopedRoleWriteAttributeHandler(Map<String, ServerGroupEffectConstraint> constraintMap) {
        super(new AttributeDefinition[]{ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS});
        this.constraintMap = constraintMap;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.applyChangeToConstraint(operation, resolvedValue);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.applyChangeToConstraint(operation, valueToRestore);
    }

    private void applyChangeToConstraint(ModelNode operation, ModelNode resolvedValue) {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServerGroupEffectConstraint constraint = this.constraintMap.get(roleName);
        if (constraint != null) {
            ArrayList<String> serverGroups = new ArrayList<String>();
            for (ModelNode group : resolvedValue.asList()) {
                serverGroups.add(group.asString());
            }
            constraint.setAllowedGroups(serverGroups);
        }
    }
}

