/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashSet;
import java.util.Map;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.models.KeycloakSession;

public class Update1_4_0
extends Update {
    @Override
    public String getId() {
        return "1.4.0";
    }

    @Override
    public void update(KeycloakSession session) throws ClassNotFoundException {
        this.deleteEntries("clientSessions");
        this.deleteEntries("sessions");
        this.removeField("realms", "authenticators");
        this.updateUserAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserAttributes() {
        DBCollection users = this.db.getCollection("users");
        try (DBCursor usersCursor = users.find();){
            while (usersCursor.hasNext()) {
                BasicDBObject user = (BasicDBObject)usersCursor.next();
                BasicDBObject attributes = (BasicDBObject)user.get("attributes");
                if (attributes == null) continue;
                for (Map.Entry attr : new HashSet(attributes.entrySet())) {
                    String attrName = (String)attr.getKey();
                    Object attrValue = attr.getValue();
                    if (attrValue == null || !(attrValue instanceof String)) continue;
                    BasicDBList asList = new BasicDBList();
                    asList.add(attrValue);
                    attributes.put((Object)attrName, (Object)asList);
                }
                user.put((Object)"attributes", (Object)attributes);
                users.save((DBObject)user);
            }
        }
    }
}

