/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;
import org.wildfly.extension.picketlink.federation.service.PicketLinkFederationService;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class FederationDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier MODULE_ORG_PICKETLINK = ModuleIdentifier.create((String)"org.picketlink");
    public static final Phase PHASE = Phase.DEPENDENCIES;
    public static final int PRIORITY = 0;
    static final AttachmentKey<PicketLinkFederationService> DEPLOYMENT_ATTACHMENT_KEY = AttachmentKey.create(PicketLinkFederationService.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceName federationServiceName = this.getFederationService(phaseContext);
        if (federationServiceName != null) {
            this.addDependency(phaseContext, federationServiceName);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private ServiceName getFederationService(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deployment = phaseContext.getDeploymentUnit();
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        ServiceController service = serviceRegistry.getService(IdentityProviderService.createServiceName(deployment.getName()));
        if (service == null) {
            service = serviceRegistry.getService(ServiceProviderService.createServiceName(deployment.getName()));
        } else {
            IdentityProviderService identityProviderService = (IdentityProviderService)service.getService();
            IDPConfiguration idpType = (IDPConfiguration)((IdentityProviderService)identityProviderService.getValue()).getConfiguration();
            if (idpType.isExternal()) {
                return null;
            }
        }
        if (service == null) {
            return null;
        }
        return service.getName();
    }

    private void addDependency(DeploymentPhaseContext phaseContext, ServiceName federationServiceName) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_ORG_PICKETLINK, false, false, true, false));
        phaseContext.addDeploymentDependency(federationServiceName, DEPLOYMENT_ATTACHMENT_KEY);
    }
}

