/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;

public abstract class JDBCImple_driver {
    protected String tableName;
    private JDBCAccess jdbcAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit_state(Uid objUid, String typeName) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        boolean result = false;
        Connection connection = null;
        Statement pstmt = null;
        Statement pstmt2 = null;
        try {
            connection = this.jdbcAccess.getConnection();
            pstmt = connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, typeName);
            pstmt.setInt(3, 1);
            int rowcount = pstmt.executeUpdate();
            if (rowcount > 0) {
                tsLogger.i18NLogger.trace_JDBCImple_previouslycommitteddeleted(rowcount);
            }
            pstmt2 = connection.prepareStatement("UPDATE " + this.tableName + " SET StateType = 1 WHERE UidString = ? AND TypeName = ? AND StateType = " + 2);
            pstmt2.setString(1, objUid.stringForm());
            pstmt2.setString(2, typeName);
            int rowcount2 = pstmt2.executeUpdate();
            if (rowcount2 > 0) {
                result = true;
                connection.commit();
            } else {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_writefailed(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstmt2 != null) {
                try {
                    pstmt2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hide_state(Uid objUid, String typeName) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        boolean result = false;
        Connection connection = null;
        Statement pstmt = null;
        try {
            connection = this.jdbcAccess.getConnection();
            pstmt = connection.prepareStatement("UPDATE " + this.tableName + " SET Hidden = 1 WHERE UidString = ? AND TypeName = ? AND Hidden = 0");
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, typeName);
            int rowcount = pstmt.executeUpdate();
            if (rowcount > 0) {
                result = true;
            }
            connection.commit();
        }
        catch (SQLException e) {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_1(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reveal_state(Uid objUid, String typeName) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        boolean result = false;
        Connection connection = null;
        Statement pstmt = null;
        try {
            connection = this.jdbcAccess.getConnection();
            pstmt = connection.prepareStatement("UPDATE " + this.tableName + " SET Hidden = 0 WHERE UidString = ? AND TypeName = ? AND Hidden = 1");
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, typeName);
            int rowcount = pstmt.executeUpdate();
            if (rowcount > 0) {
                result = true;
            }
            connection.commit();
        }
        catch (SQLException e) {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_2(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    public int currentState(Uid objUid, String typeName) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        int theState = -1;
        ResultSet rs = null;
        Connection connection = null;
        Statement pstmt = null;
        try {
            connection = this.jdbcAccess.getConnection();
            pstmt = connection.prepareStatement("SELECT StateType, Hidden FROM " + this.tableName + " WHERE UidString = ? AND TypeName = ?");
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, typeName);
            rs = pstmt.executeQuery();
            boolean have_OS_UNCOMMITTED = false;
            boolean have_OS_COMMITTED = false;
            boolean have_OS_UNCOMMITTED_HIDDEN = false;
            boolean have_OS_COMMITTED_HIDDEN = false;
            while (rs.next()) {
                int stateStatus = rs.getInt(1);
                int hidden = rs.getInt(2);
                switch (stateStatus) {
                    case 2: {
                        if (hidden == 0) {
                            have_OS_UNCOMMITTED = true;
                            break;
                        }
                        have_OS_UNCOMMITTED_HIDDEN = true;
                        break;
                    }
                    case 1: {
                        if (hidden == 0) {
                            have_OS_COMMITTED = true;
                            break;
                        }
                        have_OS_COMMITTED_HIDDEN = true;
                    }
                }
            }
            connection.commit();
            if (have_OS_COMMITTED_HIDDEN) {
                theState = 5;
            }
            if (have_OS_COMMITTED) {
                theState = 1;
            }
            if (have_OS_UNCOMMITTED_HIDDEN) {
                theState = 6;
            }
            if (have_OS_UNCOMMITTED) {
                theState = 2;
            }
        }
        catch (SQLException e) {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_3(e);
            throw new ObjectStoreException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return theState;
    }

    /*
     * Exception decompiling
     */
    public boolean allObjUids(String typeName, InputObjectState state, int match) throws ObjectStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK], 12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK], 12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove_state(Uid objUid, String typeName, int stateType) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        boolean result = false;
        if (typeName != null) {
            if (stateType == 1 || stateType == 2) {
                Connection connection = null;
                Statement pstmt = null;
                try {
                    connection = this.jdbcAccess.getConnection();
                    pstmt = connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
                    pstmt.setString(1, objUid.stringForm());
                    pstmt.setString(2, typeName);
                    pstmt.setInt(3, stateType);
                    if (pstmt.executeUpdate() > 0) {
                        result = true;
                    }
                    connection.commit();
                }
                catch (SQLException e) {
                    tsLogger.i18NLogger.warn_objectstore_JDBCImple_8(e);
                }
                finally {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            } else {
                tsLogger.i18NLogger.warn_objectstore_JDBCImple_9(Integer.toString(stateType), objUid);
            }
        } else {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_10(objUid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputObjectState read_state(Uid objUid, String typeName, int stateType) throws ObjectStoreException {
        InputObjectState result = null;
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        if (stateType == 1 || stateType == 2) {
            ResultSet rs = null;
            Connection connection = null;
            Statement pstmt = null;
            try {
                connection = this.jdbcAccess.getConnection();
                pstmt = connection.prepareStatement("SELECT ObjectState FROM " + this.tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
                pstmt.setString(1, objUid.stringForm());
                pstmt.setString(2, typeName);
                pstmt.setInt(3, stateType);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    byte[] buffer = rs.getBytes(1);
                    if (buffer != null) {
                        result = new InputObjectState(objUid, typeName, buffer);
                    } else {
                        tsLogger.i18NLogger.warn_objectstore_JDBCImple_readfailed();
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                tsLogger.i18NLogger.warn_objectstore_JDBCImple_14(e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write_state(Uid objUid, String typeName, OutputObjectState state, int stateType) throws ObjectStoreException {
        if (typeName.startsWith("/")) {
            typeName = typeName.substring(1);
        }
        boolean result = false;
        int imageSize = state.length();
        if (imageSize > this.getMaxStateSize()) {
            tsLogger.i18NLogger.warn_objectstore_JDBCImple_over_max_image_size(imageSize, this.getMaxStateSize());
        } else if (imageSize > 0) {
            byte[] b = state.buffer();
            ResultSet rs = null;
            Connection connection = null;
            Statement pstmt = null;
            try {
                connection = this.jdbcAccess.getConnection();
                pstmt = connection.prepareStatement("SELECT ObjectState, UidString, StateType, TypeName FROM " + this.tableName + " WHERE UidString = ? AND StateType = ? AND TypeName = ? FOR UPDATE", 1003, 1008);
                pstmt.setString(1, objUid.stringForm());
                pstmt.setInt(2, stateType);
                pstmt.setString(3, typeName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    try (PreparedStatement pstmt2 = connection.prepareStatement("UPDATE " + this.tableName + " SET ObjectState = ?" + " WHERE StateType=? AND TypeName=? AND UidString=?");){
                        pstmt2.setBytes(1, b);
                        pstmt2.setInt(2, stateType);
                        pstmt2.setString(3, typeName);
                        pstmt2.setString(4, objUid.stringForm());
                        pstmt2.executeUpdate();
                    }
                }
                connection.commit();
                try (PreparedStatement pstmt2 = connection.prepareStatement("INSERT INTO " + this.tableName + " (StateType,Hidden,TypeName,UidString,ObjectState) VALUES (?,0,?,?,?)");){
                    pstmt2.setInt(1, stateType);
                    pstmt2.setString(2, typeName);
                    pstmt2.setString(3, objUid.stringForm());
                    pstmt2.setBytes(4, b);
                    pstmt2.executeUpdate();
                }
                connection.commit();
                result = true;
            }
            catch (SQLException e) {
                tsLogger.i18NLogger.warn_objectstore_JDBCImple_writefailed(e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return result;
    }

    public void initialise(JDBCAccess jdbcAccess, String tableName, ObjectStoreEnvironmentBean jdbcStoreEnvironmentBean) throws SQLException, NamingException {
        this.jdbcAccess = jdbcAccess;
        try (Connection connection = jdbcAccess.getConnection();
             Statement stmt = connection.createStatement();){
            if (jdbcStoreEnvironmentBean.getDropTable()) {
                try {
                    stmt.executeUpdate("DROP TABLE " + tableName);
                }
                catch (SQLException ex) {
                    this.checkDropTableException(connection, ex);
                }
            }
            if (jdbcStoreEnvironmentBean.getCreateTable()) {
                try {
                    this.createTable(stmt, tableName);
                }
                catch (SQLException ex) {
                    this.checkCreateTableError(ex);
                }
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        this.tableName = tableName;
    }

    protected void createTable(Statement stmt, String tableName) throws SQLException {
        String statement = "CREATE TABLE " + tableName + " (StateType INTEGER NOT NULL, Hidden INTEGER NOT NULL, " + "TypeName VARCHAR(255) NOT NULL, UidString VARCHAR(255) NOT NULL, ObjectState " + this.getObjectStateSQLType() + ", PRIMARY KEY(UidString, TypeName, StateType))";
        stmt.executeUpdate(statement);
    }

    protected String getObjectStateSQLType() {
        return "bytea";
    }

    protected abstract void checkCreateTableError(SQLException var1) throws SQLException;

    protected abstract void checkDropTableException(Connection var1, SQLException var2) throws SQLException;

    public int getMaxStateSize() {
        return 65535;
    }
}

