/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.AbstractMap;
import java.util.Map;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionMetaData;

public class InfinispanSessionFactory<V, L>
implements SessionFactory<InfinispanSessionMetaData<L>, V, L> {
    private final SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> metaDataFactory;
    private final SessionAttributesFactory<V> attributesFactory;
    private final LocalContextFactory<L> localContextFactory;

    public InfinispanSessionFactory(SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> metaDataFactory, SessionAttributesFactory<V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public Map.Entry<InfinispanSessionMetaData<L>, V> createValue(String id, Void context) {
        InfinispanSessionMetaData metaDataValue = (InfinispanSessionMetaData)this.metaDataFactory.createValue(id, context);
        Object attributesValue = this.attributesFactory.createValue(id, context);
        return new AbstractMap.SimpleImmutableEntry<InfinispanSessionMetaData, Object>(metaDataValue, attributesValue);
    }

    public Map.Entry<InfinispanSessionMetaData<L>, V> findValue(String id) {
        InfinispanSessionMetaData metaDataValue = (InfinispanSessionMetaData)this.metaDataFactory.findValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.findValue(id);
            if (attributesValue != null) {
                return new AbstractMap.SimpleImmutableEntry<InfinispanSessionMetaData, Object>(metaDataValue, attributesValue);
            }
            this.metaDataFactory.remove(id);
        }
        return null;
    }

    public Map.Entry<InfinispanSessionMetaData<L>, V> tryValue(String id) {
        InfinispanSessionMetaData metaDataValue = (InfinispanSessionMetaData)this.metaDataFactory.tryValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.tryValue(id);
            if (attributesValue != null) {
                return new AbstractMap.SimpleImmutableEntry<InfinispanSessionMetaData, Object>(metaDataValue, attributesValue);
            }
            this.metaDataFactory.remove(id);
        }
        return null;
    }

    public boolean remove(String id) {
        if (this.metaDataFactory.remove(id)) {
            this.attributesFactory.remove(id);
            return true;
        }
        return false;
    }

    public void evict(String id) {
        try {
            this.metaDataFactory.evict(id);
            this.attributesFactory.evict(id);
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }

    @Override
    public SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, Map.Entry<InfinispanSessionMetaData<L>, V> entry) {
        InfinispanSessionMetaData<L> key = entry.getKey();
        SessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, key);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(id, entry.getValue());
        return new InfinispanSession<L>(id, metaData, attributes, key.getLocalContext(), this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, Map.Entry<InfinispanSessionMetaData<L>, V> entry) {
        ImmutableSessionMetaData metaData = this.metaDataFactory.createImmutableSessionMetaData(id, entry.getKey());
        ImmutableSessionAttributes attributes = this.attributesFactory.createImmutableSessionAttributes(id, entry.getValue());
        return new InfinispanImmutableSession(id, metaData, attributes);
    }
}

