/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class SingleFileImportProvider
implements ImportProvider {
    private static final Logger logger = Logger.getLogger(SingleFileImportProvider.class);
    private File file;
    protected Map<String, RealmRepresentation> realmReps;

    public SingleFileImportProvider(File file) {
        this.file = file;
    }

    public void importModel(KeycloakSessionFactory factory, final Strategy strategy) throws IOException {
        logger.infof("Full importing from file %s", (Object)this.file.getAbsolutePath());
        this.checkRealmReps();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            protected void runExportImportTask(KeycloakSession session) throws IOException {
                ImportUtils.importRealms((KeycloakSession)session, SingleFileImportProvider.this.realmReps.values(), (Strategy)strategy);
            }
        });
    }

    public boolean isMasterRealmExported() throws IOException {
        this.checkRealmReps();
        return this.realmReps.containsKey(Config.getAdminRealm());
    }

    protected void checkRealmReps() throws IOException {
        if (this.realmReps == null) {
            FileInputStream is = new FileInputStream(this.file);
            this.realmReps = ImportUtils.getRealmsFromStream((ObjectMapper)JsonSerialization.mapper, (InputStream)is);
        }
    }

    public void importRealm(KeycloakSessionFactory factory, String realmName, Strategy strategy) throws IOException {
        this.importModel(factory, strategy);
    }

    public void close() {
    }
}

