/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.ssl.XnioSsl;

public class ReverseProxyHandlerHost
extends PersistentResourceDefinition {
    public static final ReverseProxyHandlerHost INSTANCE = new ReverseProxyHandlerHost();
    public static final ServiceName SERVICE_NAME = UndertowService.HANDLER.append(new String[]{"reverse-proxy", "host"});
    public static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("outbound-socket-binding", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final AttributeDefinition SCHEME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scheme", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode("http"))).build();
    public static final AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode("/"))).build();
    public static final AttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("instance-id", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).build();

    private ReverseProxyHandlerHost() {
        super(PathElement.pathElement((String)"host"), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "reverse-proxy", "host"));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(OUTBOUND_SOCKET_BINDING, SCHEME, INSTANCE_ID, PATH, SECURITY_REALM);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReverseProxyHostAdd add = new ReverseProxyHostAdd();
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(SERVICE_NAME, add){

            protected ServiceName serviceName(String name, PathAddress address) {
                String proxyName = address.getElement(address.size() - 2).getValue();
                return SERVICE_NAME.append(new String[]{proxyName}).append(new String[]{name});
            }
        }, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    private static final class ReverseProxyHostService
    implements Service<ReverseProxyHostService> {
        private final InjectedValue<HttpHandler> proxyHandler = new InjectedValue();
        private final InjectedValue<OutboundSocketBinding> socketBinding = new InjectedValue();
        private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();
        private final String instanceId;
        private final String scheme;
        private final String path;

        private ReverseProxyHostService(String scheme, String instanceId, String path) {
            this.instanceId = instanceId;
            this.scheme = scheme;
            this.path = path;
        }

        private URI getUri() throws URISyntaxException {
            OutboundSocketBinding binding = (OutboundSocketBinding)this.socketBinding.getValue();
            return new URI(this.scheme, null, binding.getUnresolvedDestinationAddress(), binding.getDestinationPort(), this.path, null, null);
        }

        public void start(StartContext startContext) throws StartException {
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.getValue() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.getValue()).getNext() : (HttpHandler)this.proxyHandler.getValue());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                if (this.securityRealm.getOptionalValue() == null) {
                    client.addHost(this.getUri(), this.instanceId);
                } else {
                    SSLContext sslContext = ((SecurityRealm)this.securityRealm.getOptionalValue()).getSSLContext();
                    OptionMap.Builder builder = OptionMap.builder();
                    builder.set(Options.USE_DIRECT_BUFFERS, true);
                    OptionMap combined = builder.getMap();
                    UndertowXnioSsl xnioSsl = new UndertowXnioSsl(Xnio.getInstance(), combined, sslContext);
                    client.addHost(this.getUri(), this.instanceId, (XnioSsl)xnioSsl);
                }
            }
            catch (URISyntaxException e) {
                throw new StartException((Throwable)e);
            }
        }

        public void stop(StopContext stopContext) {
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.getValue() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.getValue()).getNext() : (HttpHandler)this.proxyHandler.getValue());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                client.removeHost(this.getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public ReverseProxyHostService getValue() throws IllegalStateException, IllegalArgumentException {
            return this;
        }
    }

    private final class ReverseProxyHostAdd
    extends AbstractAddStepHandler {
        private ReverseProxyHostAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : ReverseProxyHandlerHost.this.getAttributes()) {
                def.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            String proxyName = address.getElement(address.size() - 2).getValue();
            String socketBinding = OUTBOUND_SOCKET_BINDING.resolveModelAttribute(context, model).asString();
            String scheme = SCHEME.resolveModelAttribute(context, model).asString();
            String path = PATH.resolveModelAttribute(context, model).asString();
            ModelNode securityRealm = ModClusterDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
            String jvmRoute = model.hasDefined("instance-id") ? INSTANCE_ID.resolveModelAttribute(context, model).asString() : null;
            ReverseProxyHostService service = new ReverseProxyHostService(scheme, jvmRoute, path);
            ServiceBuilder builder = context.getServiceTarget().addService(SERVICE_NAME.append(new String[]{proxyName}).append(new String[]{name}), (Service)service).addDependency(UndertowService.HANDLER.append(new String[]{proxyName}), HttpHandler.class, (Injector)service.proxyHandler).addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{socketBinding}), OutboundSocketBinding.class, (Injector)service.socketBinding);
            if (securityRealm.isDefined()) {
                SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, (Injector)service.securityRealm, (String)securityRealm.asString(), (boolean)false);
            }
            builder.install();
        }
    }
}

