/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.jboss.as.clustering.infinispan.DefaultCache;
import org.jboss.as.clustering.infinispan.InfinispanBatcherFactory;
import org.wildfly.clustering.infinispan.spi.CacheContainer;

public class DefaultCacheContainer
extends AbstractDelegatingEmbeddedCacheManager
implements CacheContainer {
    private final String name;
    private final BatcherFactory batcherFactory;
    private final String defaultCacheName;

    public DefaultCacheContainer(String name, EmbeddedCacheManager container, String defaultCacheName) {
        this(name, container, defaultCacheName, new InfinispanBatcherFactory());
    }

    public DefaultCacheContainer(String name, EmbeddedCacheManager container, String defaultCacheName, BatcherFactory batcherFactory) {
        super(container);
        this.name = name;
        this.defaultCacheName = defaultCacheName;
        this.batcherFactory = batcherFactory;
    }

    public String getName() {
        return this.name;
    }

    public void start() {
    }

    public void stop() {
    }

    public String getDefaultCacheName() {
        return this.defaultCacheName;
    }

    public Configuration defineConfiguration(String cacheName, Configuration configuration) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configuration);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), this.getCacheName(templateCacheName), configurationOverride);
    }

    public void undefineConfiguration(String cacheName) {
        this.cm.undefineConfiguration(this.getCacheName(cacheName));
    }

    public Configuration getDefaultCacheConfiguration() {
        return this.cm.getCacheConfiguration(this.defaultCacheName);
    }

    public Configuration getCacheConfiguration(String name) {
        return this.cm.getCacheConfiguration(this.getCacheName(name));
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache(this.defaultCacheName);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, cacheName);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, String configurationName) {
        PrivilegedAction<Cache> action = () -> this.cm.getCache(this.getCacheName(cacheName), this.getCacheName(configurationName));
        Cache cache = System.getSecurityManager() == null ? action.run() : AccessController.doPrivileged(action);
        return cache != null ? new DefaultCache((EmbeddedCacheManager)this, this.batcherFactory, cache.getAdvancedCache()) : null;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        return this.getCache(cacheName, cacheName, createIfAbsent);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, String configurationTemplate, boolean createIfAbsent) {
        boolean cacheExists = this.cacheExists(cacheName);
        return cacheExists || createIfAbsent ? this.getCache(cacheName, configurationTemplate) : null;
    }

    public boolean isDefaultRunning() {
        return this.cm.isRunning(this.defaultCacheName);
    }

    public boolean isRunning(String cacheName) {
        return this.cm.isRunning(this.getCacheName(cacheName));
    }

    public boolean cacheExists(String cacheName) {
        return this.cm.cacheExists(this.getCacheName(cacheName));
    }

    public void removeCache(String cacheName) {
        this.cm.removeCache(this.getCacheName(cacheName));
    }

    public EmbeddedCacheManager startCaches(String ... names) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>();
        for (String name : names) {
            cacheNames.add(this.getCacheName(name));
        }
        this.cm.startCaches(cacheNames.toArray(new String[cacheNames.size()]));
        return this;
    }

    public void addCacheDependency(String from, String to) {
        this.cm.addCacheDependency(this.getCacheName(from), this.getCacheName(to));
    }

    private String getCacheName(String name) {
        return name == null || name.equals("default") ? this.defaultCacheName : name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.cm.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
    }
}

