/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionContext;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class BeanEvictionCommand<I>
implements Command<Void, BeanEvictionContext<I>> {
    private static final long serialVersionUID = -6593293772761100784L;
    private final I id;

    public BeanEvictionCommand(I id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void execute(BeanEvictionContext<I> context) throws Exception {
        Batch batch = context.getBatcher().createBatch();
        boolean success = false;
        try {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Evicting stateful session bean %s", this.id);
            context.getEvictor().evict(this.id);
            success = true;
        }
        finally {
            if (success) {
                batch.close();
            } else {
                batch.discard();
            }
        }
        return null;
    }
}

