/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.JournalType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.ActiveMQServerControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQServerControlWriteHandler;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.AddressSettingsResolveHandler;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConnectorServiceDefinition;
import org.wildfly.extension.messaging.activemq.CoreAddressDefinition;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.DivertDefinition;
import org.wildfly.extension.messaging.activemq.ExportJournalOperation;
import org.wildfly.extension.messaging.activemq.GenericTransportDefinition;
import org.wildfly.extension.messaging.activemq.GroupingHandlerDefinition;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.ImportJournalOperation;
import org.wildfly.extension.messaging.activemq.InVMTransportDefinition;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.QueueDefinition;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.SecuritySettingDefinition;
import org.wildfly.extension.messaging.activemq.ServerAdd;
import org.wildfly.extension.messaging.activemq.ServerRemove;
import org.wildfly.extension.messaging.activemq.ha.LiveOnlyDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationSlaveDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreSlaveDefinition;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSServerControlHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryDefinition;

public class ServerDefinition
extends PersistentResourceDefinition {
    public static final SimpleAttributeDefinition CLUSTER_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-password", (ModelType)ModelType.STRING).setAttributeGroup("cluster")).setXmlName("password")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultClusterPassword()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition CLUSTER_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-user", (ModelType)ModelType.STRING).setAttributeGroup("cluster")).setXmlName("user")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultClusterUser()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-domain", (ModelType)ModelType.STRING).setAttributeGroup("security")).setXmlName("domain")).setDefaultValue(new ModelNode("other"))).setAllowNull(true)).setAllowExpression(false)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final AttributeDefinition THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition OVERRIDE_IN_VM_SECURITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"override-in-vm-security", (ModelType)ModelType.BOOLEAN).setAttributeGroup("security")).setDefaultValue(new ModelNode(true))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition WILD_CARD_ROUTING_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"wild-card-routing-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultWildcardRoutingEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"statistics-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("statistics")).setXmlName("enabled")).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-size", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("buffer-size")).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-timeout", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("buffer-timeout")).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-min-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("compact-min-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_PERCENTAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-percentage", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("compact-percentage")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_FILE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-file-size", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("file-size")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalFileSize()))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MAX_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-max-io", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("max-io")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-min-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("min-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalMinFiles()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(2, true, true))).build();
    public static final SimpleAttributeDefinition JOURNAL_POOL_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-pool-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("pool-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalPoolFiles()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_NON_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-non-transactional", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("sync-non-transactional")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-transactional", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("sync-transactional")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-type", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("type")).setDefaultValue(new ModelNode(ConfigurationImpl.DEFAULT_JOURNAL_TYPE.toString()))).setAllowNull(true)).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(JournalType.class, true, true))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition LOG_JOURNAL_WRITE_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-journal-write-rate", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("log-write-rate")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL_OVERRIDE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl-override", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ASYNC_CONNECTION_EXECUTION_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"async-connection-execution-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_MAX_DAY_HISTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-max-day-history", (ModelType)ModelType.INT).setAttributeGroup("statistics")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory()))).setMeasurementUnit(MeasurementUnit.DAYS)).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_SAMPLE_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-sample-period", (ModelType)ModelType.LONG).setAttributeGroup("statistics")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout", (ModelType)ModelType.LONG).setAttributeGroup("transaction")).setXmlName("timeout")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultTransactionTimeout()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout-scan-period", (ModelType)ModelType.LONG).setAttributeGroup("transaction")).setXmlName("scan-period")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-scan-period", (ModelType)ModelType.LONG).setAttributeGroup("message-expiry")).setXmlName("scan-period")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_THREAD_PRIORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-thread-priority", (ModelType)ModelType.INT).setAttributeGroup("message-expiry")).setXmlName("thread-priority")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageExpiryThreadPriority()))).setAllowNull(true)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, 10, true, true))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERF_BLAST_PAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"perf-blast-pages", (ModelType)ModelType.INT).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalPerfBlastPages()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RUN_SYNC_SPEED_TEST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"run-sync-speed-test", (ModelType)ModelType.BOOLEAN).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultRunSyncSpeedTest()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SERVER_DUMP_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-dump-interval", (ModelType)ModelType.LONG).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultServerDumpInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_MEASURE_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-measure-interval", (ModelType)ModelType.LONG).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMemoryMeasureInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_WARNING_THRESHOLD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-warning-threshold", (ModelType)ModelType.INT).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMemoryWarningThreshold()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SECURITY_INVALIDATION_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-invalidation-interval", (ModelType)ModelType.LONG).setAttributeGroup("security")).setXmlName("invalidation-interval")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("security")).setXmlName("enabled")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultSecurityEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition PERSISTENCE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persistence-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistenceEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MANAGEMENT_NOTIFICATION_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-notification-address", (ModelType)ModelType.STRING).setAttributeGroup("management")).setXmlName("notification-address")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-address", (ModelType)ModelType.STRING).setAttributeGroup("management")).setXmlName("address")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition JMX_MANAGEMENT_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-management-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("management")).setXmlName("jmx-enabled")).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition JMX_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-domain", (ModelType)ModelType.STRING).setAttributeGroup("management")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJmxDomain()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition PERSIST_ID_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-id-cache", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistIdCache()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-delivery-count-before-delivery", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ID_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"id-cache-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultIdCacheSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PAGE_MAX_CONCURRENT_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"page-max-concurrent-io", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMaxConcurrentPageIo()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_BINDINGS_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-bindings-dir", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_JOURNAL_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-journal-dir", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultCreateJournalDir()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PERSISTENCE_ENABLED, SCHEDULED_THREAD_POOL_MAX_SIZE, THREAD_POOL_MAX_SIZE, SECURITY_DOMAIN, SECURITY_ENABLED, SECURITY_INVALIDATION_INTERVAL, OVERRIDE_IN_VM_SECURITY, WILD_CARD_ROUTING_ENABLED, MANAGEMENT_ADDRESS, MANAGEMENT_NOTIFICATION_ADDRESS, CLUSTER_USER, CLUSTER_PASSWORD, JMX_MANAGEMENT_ENABLED, JMX_DOMAIN, STATISTICS_ENABLED, MESSAGE_COUNTER_SAMPLE_PERIOD, MESSAGE_COUNTER_MAX_DAY_HISTORY, CONNECTION_TTL_OVERRIDE, ASYNC_CONNECTION_EXECUTION_ENABLED, TRANSACTION_TIMEOUT, TRANSACTION_TIMEOUT_SCAN_PERIOD, MESSAGE_EXPIRY_SCAN_PERIOD, MESSAGE_EXPIRY_THREAD_PRIORITY, ID_CACHE_SIZE, PERSIST_ID_CACHE, CommonAttributes.INCOMING_INTERCEPTORS, CommonAttributes.OUTGOING_INTERCEPTORS, PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, PAGE_MAX_CONCURRENT_IO, CREATE_BINDINGS_DIR, CREATE_JOURNAL_DIR, JOURNAL_TYPE, JOURNAL_BUFFER_TIMEOUT, JOURNAL_BUFFER_SIZE, JOURNAL_SYNC_TRANSACTIONAL, JOURNAL_SYNC_NON_TRANSACTIONAL, LOG_JOURNAL_WRITE_RATE, JOURNAL_FILE_SIZE, JOURNAL_MIN_FILES, JOURNAL_POOL_FILES, JOURNAL_COMPACT_PERCENTAGE, JOURNAL_COMPACT_MIN_FILES, JOURNAL_MAX_IO, PERF_BLAST_PAGES, RUN_SYNC_SPEED_TEST, SERVER_DUMP_INTERVAL, MEMORY_WARNING_THRESHOLD, MEMORY_MEASURE_INTERVAL};
    static final String JMX_CAPABILITY = "org.wildfly.management.jmx";
    static final RuntimeCapability<Void> ACTIVEMQ_SERVER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.server", (boolean)true).addOptionalRequirements(new String[]{"org.wildfly.management.jmx"}).build();
    private static PersistentResourceDefinition[] CHILDREN = new PersistentResourceDefinition[]{LiveOnlyDefinition.INSTANCE, ReplicationMasterDefinition.INSTANCE, ReplicationSlaveDefinition.INSTANCE, ReplicationColocatedDefinition.INSTANCE, SharedStoreMasterDefinition.INSTANCE, SharedStoreSlaveDefinition.INSTANCE, SharedStoreColocatedDefinition.INSTANCE, AddressSettingDefinition.INSTANCE, SecuritySettingDefinition.INSTANCE, HTTPConnectorDefinition.INSTANCE, RemoteTransportDefinition.CONNECTOR_INSTANCE, InVMTransportDefinition.CONNECTOR_INSTANCE, GenericTransportDefinition.CONNECTOR_INSTANCE, HTTPAcceptorDefinition.INSTANCE, RemoteTransportDefinition.ACCEPTOR_INSTANCE, InVMTransportDefinition.ACCEPTOR_INSTANCE, GenericTransportDefinition.ACCEPTOR_INSTANCE, QueueDefinition.INSTANCE, BroadcastGroupDefinition.INSTANCE, DiscoveryGroupDefinition.INSTANCE, BridgeDefinition.INSTANCE, ClusterConnectionDefinition.INSTANCE, DivertDefinition.INSTANCE, ConnectorServiceDefinition.INSTANCE, GroupingHandlerDefinition.INSTANCE, JMSQueueDefinition.INSTANCE, JMSTopicDefinition.INSTANCE, ConnectionFactoryDefinition.INSTANCE, LegacyConnectionFactoryDefinition.INSTANCE, PooledConnectionFactoryDefinition.INSTANCE};
    protected static final PersistentResourceDefinition INSTANCE = new ServerDefinition(false);
    private final boolean registerRuntimeOnly;

    ServerDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("server"), (OperationStepHandler)ServerAdd.INSTANCE, (OperationStepHandler)ServerRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ExportJournalOperation.registerOperation(resourceRegistration, this.getResourceDescriptionResolver());
        ImportJournalOperation.registerOperation(resourceRegistration, this.getResourceDescriptionResolver());
        if (this.registerRuntimeOnly) {
            ActiveMQServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            JMSServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            AddressSettingsResolveHandler.registerOperationHandler(resourceRegistration, this.getResourceDescriptionResolver());
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQServerControlWriteHandler.INSTANCE.registerAttributes(resourceRegistration, this.registerRuntimeOnly);
        if (this.registerRuntimeOnly) {
            ActiveMQServerControlHandler.INSTANCE.registerAttributes(resourceRegistration);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(CHILDREN);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        ManagementResourceRegistration runtimeQueue = resourceRegistration.registerSubModel((ResourceDefinition)QueueDefinition.RUNTIME_INSTANCE);
        runtimeQueue.setRuntimeOnly(true);
        ManagementResourceRegistration coreAddress = resourceRegistration.registerSubModel((ResourceDefinition)CoreAddressDefinition.INSTANCE);
        coreAddress.setRuntimeOnly(true);
    }
}

