/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.ha.LiveOnlyDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationSlaveDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreSlaveDefinition;

public class HAPolicyConfigurationBuilder {
    public static void addHAPolicyConfiguration(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        HAPolicyConfiguration haPolicyConfiguration;
        String type;
        if (!model.hasDefined("ha-policy")) {
            return;
        }
        Property prop = model.get("ha-policy").asProperty();
        ModelNode haPolicy = prop.getValue();
        switch (type = prop.getName()) {
            case "live-only": {
                haPolicyConfiguration = LiveOnlyDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "replication-master": {
                haPolicyConfiguration = ReplicationMasterDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "replication-slave": {
                haPolicyConfiguration = ReplicationSlaveDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "replication-colocated": {
                haPolicyConfiguration = ReplicationColocatedDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-master": {
                haPolicyConfiguration = SharedStoreMasterDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-slave": {
                haPolicyConfiguration = SharedStoreSlaveDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-colocated": {
                haPolicyConfiguration = SharedStoreColocatedDefinition.buildConfiguration(context, haPolicy);
                break;
            }
            default: {
                throw new OperationFailedException("unknown ha policy type");
            }
        }
        configuration.setHAPolicyConfiguration(haPolicyConfiguration);
    }
}

