/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.partialimport.ErrorResponseException;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.services.ErrorResponse;

public abstract class AbstractPartialImport<T>
implements PartialImport<T> {
    protected static Logger logger = Logger.getLogger(AbstractPartialImport.class);
    protected final Set<T> toOverwrite = new HashSet<T>();
    protected final Set<T> toSkip = new HashSet<T>();

    public abstract List<T> getRepList(PartialImportRepresentation var1);

    public abstract String getName(T var1);

    public abstract String getModelId(RealmModel var1, KeycloakSession var2, T var3);

    public abstract boolean exists(RealmModel var1, KeycloakSession var2, T var3);

    public abstract String existsMessage(T var1);

    public abstract ResourceType getResourceType();

    public abstract void remove(RealmModel var1, KeycloakSession var2, T var3);

    public abstract void create(RealmModel var1, KeycloakSession var2, T var3);

    @Override
    public void prepare(PartialImportRepresentation partialImportRep, RealmModel realm, KeycloakSession session) throws ErrorResponseException {
        List<T> repList = this.getRepList(partialImportRep);
        if (repList == null || repList.isEmpty()) {
            return;
        }
        block4: for (T resourceRep : this.getRepList(partialImportRep)) {
            if (!this.exists(realm, session, resourceRep)) continue;
            switch (partialImportRep.getPolicy()) {
                case SKIP: {
                    this.toSkip.add(resourceRep);
                    continue block4;
                }
                case OVERWRITE: {
                    this.toOverwrite.add(resourceRep);
                    continue block4;
                }
            }
            throw this.existsError(this.existsMessage(resourceRep));
        }
    }

    protected ErrorResponseException existsError(String message) {
        Response error = ErrorResponse.exists(message);
        return new ErrorResponseException(error);
    }

    protected PartialImportResult overwritten(String modelId, T resourceRep) {
        return PartialImportResult.overwritten(this.getResourceType(), this.getName(resourceRep), modelId, resourceRep);
    }

    protected PartialImportResult skipped(String modelId, T resourceRep) {
        return PartialImportResult.skipped(this.getResourceType(), this.getName(resourceRep), modelId, resourceRep);
    }

    protected PartialImportResult added(String modelId, T resourceRep) {
        return PartialImportResult.added(this.getResourceType(), this.getName(resourceRep), modelId, resourceRep);
    }

    @Override
    public void removeOverwrites(RealmModel realm, KeycloakSession session) {
        for (T resourceRep : this.toOverwrite) {
            this.remove(realm, session, resourceRep);
        }
    }

    @Override
    public PartialImportResults doImport(PartialImportRepresentation partialImportRep, RealmModel realm, KeycloakSession session) throws ErrorResponseException {
        String modelId;
        PartialImportResults results = new PartialImportResults();
        List<T> repList = this.getRepList(partialImportRep);
        if (repList == null || repList.isEmpty()) {
            return results;
        }
        for (T resourceRep : this.toOverwrite) {
            try {
                this.create(realm, session, resourceRep);
            }
            catch (Exception e) {
                logger.error((Object)("Error overwriting " + this.getName(resourceRep)), (Throwable)e);
                throw new ErrorResponseException(ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR));
            }
            modelId = this.getModelId(realm, session, resourceRep);
            results.addResult(this.overwritten(modelId, resourceRep));
        }
        for (T resourceRep : this.toSkip) {
            modelId = this.getModelId(realm, session, resourceRep);
            results.addResult(this.skipped(modelId, resourceRep));
        }
        for (T resourceRep : repList) {
            if (this.toOverwrite.contains(resourceRep) || this.toSkip.contains(resourceRep)) continue;
            try {
                this.create(realm, session, resourceRep);
                modelId = this.getModelId(realm, session, resourceRep);
                results.addResult(this.added(modelId, resourceRep));
            }
            catch (Exception e) {
                logger.error((Object)("Error creating " + this.getName(resourceRep)), (Throwable)e);
                throw new ErrorResponseException(ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR));
            }
        }
        return results;
    }
}

